/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.SecureData;
import telegram4j.tl.SecureFile;
import telegram4j.tl.SecurePlainData;
import telegram4j.tl.SecureValue;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureValue
implements SecureValue {
    private final int identifier;
    private final int flags;
    private final SecureValueType type;
    @Nullable
    private final SecureData data;
    @Nullable
    private final SecureFile frontSide;
    @Nullable
    private final SecureFile reverseSide;
    @Nullable
    private final SecureFile selfie;
    @Nullable
    private final List<SecureFile> translation;
    @Nullable
    private final List<SecureFile> files;
    @Nullable
    private final SecurePlainData plainData;
    private final ByteBuf hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecureValue(SecureValueType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.data = null;
        this.frontSide = null;
        this.reverseSide = null;
        this.selfie = null;
        this.translation = null;
        this.files = null;
        this.plainData = null;
        this.hash = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSecureValue(Builder builder) {
        this.type = builder.type;
        this.data = builder.data;
        this.frontSide = builder.frontSide;
        this.reverseSide = builder.reverseSide;
        this.selfie = builder.selfie;
        this.translation = builder.translation == null ? null : ImmutableSecureValue.createUnmodifiableList(true, builder.translation);
        this.files = builder.files == null ? null : ImmutableSecureValue.createUnmodifiableList(true, builder.files);
        this.plainData = builder.plainData;
        this.hash = builder.hash_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableSecureValue(int identifier, int flags, SecureValueType type, @Nullable SecureData data, @Nullable SecureFile frontSide, @Nullable SecureFile reverseSide, @Nullable SecureFile selfie, @Nullable List<SecureFile> translation, @Nullable List<SecureFile> files, @Nullable SecurePlainData plainData, ByteBuf hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.type = type;
        this.data = data;
        this.frontSide = frontSide;
        this.reverseSide = reverseSide;
        this.selfie = selfie;
        this.translation = translation;
        this.files = files;
        this.plainData = plainData;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecureValue.super.identifier();
    }

    private int flagsInitialize() {
        return SecureValue.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    @Override
    @Nullable
    public SecureData data() {
        return this.data;
    }

    @Override
    @Nullable
    public SecureFile frontSide() {
        return this.frontSide;
    }

    @Override
    @Nullable
    public SecureFile reverseSide() {
        return this.reverseSide;
    }

    @Override
    @Nullable
    public SecureFile selfie() {
        return this.selfie;
    }

    @Override
    @Nullable
    public List<SecureFile> translation() {
        return this.translation;
    }

    @Override
    @Nullable
    public List<SecureFile> files() {
        return this.files;
    }

    @Override
    @Nullable
    public SecurePlainData plainData() {
        return this.plainData;
    }

    @Override
    public ByteBuf hash() {
        return this.hash.duplicate();
    }

    public final ImmutableSecureValue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureValue(value, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, value, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, newValue, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withData(@Nullable SecureData value) {
        if (this.data == value) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, value, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withFrontSide(@Nullable SecureFile value) {
        if (this.frontSide == value) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, value, this.reverseSide, this.selfie, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withReverseSide(@Nullable SecureFile value) {
        if (this.reverseSide == value) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, value, this.selfie, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withSelfie(@Nullable SecureFile value) {
        if (this.selfie == value) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, value, this.translation, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withTranslation(SecureFile ... elements) {
        if (elements == null) {
            return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, null, this.files, this.plainData, this.hash);
        }
        List<SecureFile> newValue = Arrays.asList(elements) == null ? null : ImmutableSecureValue.createUnmodifiableList(false, ImmutableSecureValue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, newValue, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withTranslation(@Nullable Iterable<? extends SecureFile> elements) {
        if (this.translation == elements) {
            return this;
        }
        List<SecureFile> newValue = elements == null ? null : ImmutableSecureValue.createUnmodifiableList(false, ImmutableSecureValue.createSafeList(elements, true, false));
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, newValue, this.files, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withFiles(SecureFile ... elements) {
        if (elements == null) {
            return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, null, this.plainData, this.hash);
        }
        List<SecureFile> newValue = Arrays.asList(elements) == null ? null : ImmutableSecureValue.createUnmodifiableList(false, ImmutableSecureValue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, newValue, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withFiles(@Nullable Iterable<? extends SecureFile> elements) {
        if (this.files == elements) {
            return this;
        }
        List<SecureFile> newValue = elements == null ? null : ImmutableSecureValue.createUnmodifiableList(false, ImmutableSecureValue.createSafeList(elements, true, false));
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, newValue, this.plainData, this.hash);
    }

    public final ImmutableSecureValue withPlainData(@Nullable SecurePlainData value) {
        if (this.plainData == value) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, value, this.hash);
    }

    public ImmutableSecureValue withHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.hash == newValue) {
            return this;
        }
        return new ImmutableSecureValue(this.identifier, this.flags, this.type, this.data, this.frontSide, this.reverseSide, this.selfie, this.translation, this.files, this.plainData, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureValue && this.equalTo(0, (ImmutableSecureValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureValue another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.type.equals((Object)another.type) && Objects.equals(this.data, another.data) && Objects.equals(this.frontSide, another.frontSide) && Objects.equals(this.reverseSide, another.reverseSide) && Objects.equals(this.selfie, another.selfie) && Objects.equals(this.translation, another.translation) && Objects.equals(this.files, another.files) && Objects.equals(this.plainData, another.plainData) && this.hash().equals((Object)another.hash());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.frontSide);
        h += (h << 5) + Objects.hashCode(this.reverseSide);
        h += (h << 5) + Objects.hashCode(this.selfie);
        h += (h << 5) + Objects.hashCode(this.translation);
        h += (h << 5) + Objects.hashCode(this.files);
        h += (h << 5) + Objects.hashCode(this.plainData);
        h += (h << 5) + this.hash().hashCode();
        return h;
    }

    public String toString() {
        return "SecureValue{identifier=" + this.identifier + ", flags=" + this.flags + ", type=" + this.type + ", data=" + this.data + ", frontSide=" + this.frontSide + ", reverseSide=" + this.reverseSide + ", selfie=" + this.selfie + ", translation=" + this.translation + ", files=" + this.files + ", plainData=" + this.plainData + ", hash=" + ByteBufUtil.hexDump((ByteBuf)this.hash) + "}";
    }

    public static ImmutableSecureValue of(SecureValueType type) {
        return new ImmutableSecureValue(type);
    }

    public static ImmutableSecureValue copyOf(SecureValue instance) {
        if (instance instanceof ImmutableSecureValue) {
            return (ImmutableSecureValue)instance;
        }
        return ImmutableSecureValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf hash_value = null;
        private int identifier;
        private int flags;
        private SecureValueType type;
        private SecureData data;
        private SecureFile frontSide;
        private SecureFile reverseSide;
        private SecureFile selfie;
        private List<SecureFile> translation = null;
        private List<SecureFile> files = null;
        private SecurePlainData plainData;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecureValue) {
                List<SecureFile> filesValue;
                SecureFile selfieValue;
                SecureFile reverseSideValue;
                SecureData dataValue;
                SecurePlainData plainDataValue;
                instance = (SecureValue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((plainDataValue = instance.plainData()) != null) {
                    this.plainData(plainDataValue);
                }
                if ((dataValue = instance.data()) != null) {
                    this.data(dataValue);
                }
                if ((reverseSideValue = instance.reverseSide()) != null) {
                    this.reverseSide(reverseSideValue);
                }
                if ((selfieValue = instance.selfie()) != null) {
                    this.selfie(selfieValue);
                }
                this.flags(instance.flags());
                List<SecureFile> translationValue = instance.translation();
                if (translationValue != null) {
                    this.addAllTranslation(translationValue);
                }
                if ((filesValue = instance.files()) != null) {
                    this.addAllFiles(filesValue);
                }
                this.type(instance.type());
                SecureFile frontSideValue = instance.frontSide();
                if (frontSideValue != null) {
                    this.frontSide(frontSideValue);
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(@Nullable SecureData data) {
            this.data = data;
            return this;
        }

        public final Builder frontSide(@Nullable SecureFile frontSide) {
            this.frontSide = frontSide;
            return this;
        }

        public final Builder reverseSide(@Nullable SecureFile reverseSide) {
            this.reverseSide = reverseSide;
            return this;
        }

        public final Builder selfie(@Nullable SecureFile selfie) {
            this.selfie = selfie;
            return this;
        }

        public final Builder addTranslation(SecureFile element) {
            if (this.translation == null) {
                this.translation = new ArrayList<SecureFile>();
            }
            this.translation.add(Objects.requireNonNull(element, "translation element"));
            return this;
        }

        public final Builder addTranslation(SecureFile ... elements) {
            if (this.translation == null) {
                this.translation = new ArrayList<SecureFile>();
            }
            for (SecureFile element : elements) {
                this.translation.add(Objects.requireNonNull(element, "translation element"));
            }
            return this;
        }

        public final Builder translation(@Nullable Iterable<? extends SecureFile> elements) {
            if (elements == null) {
                this.translation = null;
                return this;
            }
            this.translation = new ArrayList<SecureFile>();
            return this.addAllTranslation(elements);
        }

        public final Builder addAllTranslation(Iterable<? extends SecureFile> elements) {
            Objects.requireNonNull(elements, "translation element");
            if (this.translation == null) {
                this.translation = new ArrayList<SecureFile>();
            }
            for (SecureFile secureFile : elements) {
                this.translation.add(Objects.requireNonNull(secureFile, "translation element"));
            }
            return this;
        }

        public final Builder addFile(SecureFile element) {
            if (this.files == null) {
                this.files = new ArrayList<SecureFile>();
            }
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(SecureFile ... elements) {
            if (this.files == null) {
                this.files = new ArrayList<SecureFile>();
            }
            for (SecureFile element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        public final Builder files(@Nullable Iterable<? extends SecureFile> elements) {
            if (elements == null) {
                this.files = null;
                return this;
            }
            this.files = new ArrayList<SecureFile>();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends SecureFile> elements) {
            Objects.requireNonNull(elements, "files element");
            if (this.files == null) {
                this.files = new ArrayList<SecureFile>();
            }
            for (SecureFile secureFile : elements) {
                this.files.add(Objects.requireNonNull(secureFile, "files element"));
            }
            return this;
        }

        public final Builder plainData(@Nullable SecurePlainData plainData) {
            this.plainData = plainData;
            return this;
        }

        public Builder hash(ByteBuf value) {
            this.hash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSecureValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecureValue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build SecureValue, some of required attributes are not set " + attributes;
        }

        private ByteBuf hash_build() {
            return Objects.requireNonNull(this.hash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecureValue.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSecureValue.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build SecureValue, attribute initializers form cycle " + attributes;
        }
    }
}

