/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecureValueError;
import telegram4j.tl.SecureValueErrorData;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureValueErrorData
implements SecureValueErrorData {
    private final int identifier;
    private final SecureValueType type;
    private final ByteBuf dataHash;
    private final String field;
    private final String text;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecureValueErrorData(SecureValueType type, String field, String text) {
        this.type = Objects.requireNonNull(type, "type");
        this.field = Objects.requireNonNull(field, "field");
        this.text = Objects.requireNonNull(text, "text");
        this.dataHash = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureValueErrorData(Builder builder) {
        this.type = builder.type;
        this.dataHash = builder.dataHash_build();
        this.field = builder.field;
        this.text = builder.text;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureValueErrorData(int identifier, SecureValueType type, ByteBuf dataHash, String field, String text) {
        this.identifier = identifier;
        this.type = type;
        this.dataHash = dataHash;
        this.field = field;
        this.text = text;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecureValueErrorData.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    @Override
    public ByteBuf dataHash() {
        return this.dataHash.duplicate();
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableSecureValueErrorData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureValueErrorData(value, this.type, this.dataHash, this.field, this.text);
    }

    public final ImmutableSecureValueErrorData withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableSecureValueErrorData(this.identifier, newValue, this.dataHash, this.field, this.text);
    }

    public ImmutableSecureValueErrorData withDataHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.dataHash == newValue) {
            return this;
        }
        return new ImmutableSecureValueErrorData(this.identifier, this.type, newValue, this.field, this.text);
    }

    public final ImmutableSecureValueErrorData withField(String value) {
        String newValue = Objects.requireNonNull(value, "field");
        if (this.field.equals(newValue)) {
            return this;
        }
        return new ImmutableSecureValueErrorData(this.identifier, this.type, this.dataHash, newValue, this.text);
    }

    public final ImmutableSecureValueErrorData withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableSecureValueErrorData(this.identifier, this.type, this.dataHash, this.field, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureValueErrorData && this.equalTo(0, (ImmutableSecureValueErrorData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureValueErrorData another) {
        return this.identifier == another.identifier && this.type.equals((Object)another.type) && this.dataHash().equals((Object)another.dataHash()) && this.field.equals(another.field) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.dataHash().hashCode();
        h += (h << 5) + this.field.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "SecureValueErrorData{identifier=" + this.identifier + ", type=" + this.type + ", dataHash=" + ByteBufUtil.hexDump((ByteBuf)this.dataHash) + ", field=" + this.field + ", text=" + this.text + "}";
    }

    public static ImmutableSecureValueErrorData of(SecureValueType type, String field, String text) {
        return new ImmutableSecureValueErrorData(type, field, text);
    }

    public static ImmutableSecureValueErrorData copyOf(SecureValueErrorData instance) {
        if (instance instanceof ImmutableSecureValueErrorData) {
            return (ImmutableSecureValueErrorData)instance;
        }
        return ImmutableSecureValueErrorData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_FIELD = 2L;
        private static final long INIT_BIT_TEXT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf dataHash_value = null;
        private int identifier;
        private SecureValueType type;
        private String field;
        private String text;

        private Builder() {
        }

        public final Builder from(SecureValueErrorData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureValueError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureValueError instance;
            long bits = 0L;
            if (object instanceof SecureValueErrorData) {
                instance = (SecureValueErrorData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                this.field(instance.field());
                if ((bits & 4L) == 0L) {
                    this.type(instance.type());
                    bits |= 4L;
                }
                this.dataHash(instance.dataHash());
            }
            if (object instanceof SecureValueError) {
                instance = (SecureValueError)object;
                if ((bits & 4L) == 0L) {
                    this.type(instance.type());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder dataHash(ByteBuf value) {
            this.dataHash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder field(String field) {
            this.field = Objects.requireNonNull(field, "field");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSecureValueErrorData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecureValueErrorData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("field");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build SecureValueErrorData, some of required attributes are not set " + attributes;
        }

        private ByteBuf dataHash_build() {
            return Objects.requireNonNull(this.dataHash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecureValueErrorData.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SecureValueErrorData, attribute initializers form cycle " + attributes;
        }
    }
}

