/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import telegram4j.tl.SecureValueError;
import telegram4j.tl.SecureValueErrorTranslationFiles;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureValueErrorTranslationFiles
implements SecureValueErrorTranslationFiles {
    private final int identifier;
    private final SecureValueType type;
    private final List<ByteBuf> fileHash;
    private final String text;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecureValueErrorTranslationFiles(SecureValueType type, String text) {
        this.type = Objects.requireNonNull(type, "type");
        this.text = Objects.requireNonNull(text, "text");
        this.fileHash = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureValueErrorTranslationFiles(Builder builder) {
        this.type = builder.type;
        this.fileHash = builder.fileHash_build();
        this.text = builder.text;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureValueErrorTranslationFiles(int identifier, SecureValueType type, List<ByteBuf> fileHash, String text) {
        this.identifier = identifier;
        this.type = type;
        this.fileHash = fileHash;
        this.text = text;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecureValueErrorTranslationFiles.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    @Override
    public List<ByteBuf> fileHash() {
        return this.fileHash.stream().map(ByteBuf::duplicate).collect(Collectors.toList());
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableSecureValueErrorTranslationFiles withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureValueErrorTranslationFiles(value, this.type, this.fileHash, this.text);
    }

    public final ImmutableSecureValueErrorTranslationFiles withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableSecureValueErrorTranslationFiles(this.identifier, newValue, this.fileHash, this.text);
    }

    public ImmutableSecureValueErrorTranslationFiles withFileHash(Iterable<? extends ByteBuf> value) {
        List<ByteBuf> newValue = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
        if (this.fileHash == newValue) {
            return this;
        }
        return new ImmutableSecureValueErrorTranslationFiles(this.identifier, this.type, newValue, this.text);
    }

    public final ImmutableSecureValueErrorTranslationFiles withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableSecureValueErrorTranslationFiles(this.identifier, this.type, this.fileHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureValueErrorTranslationFiles && this.equalTo(0, (ImmutableSecureValueErrorTranslationFiles)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureValueErrorTranslationFiles another) {
        return this.identifier == another.identifier && this.type.equals((Object)another.type) && this.fileHash().equals(another.fileHash()) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.fileHash().hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "SecureValueErrorTranslationFiles{identifier=" + this.identifier + ", type=" + this.type + ", fileHash=" + this.fileHash.stream().map(ByteBufUtil::hexDump).collect(Collectors.joining(", ", "[", "]")) + ", text=" + this.text + "}";
    }

    public static ImmutableSecureValueErrorTranslationFiles of(SecureValueType type, String text) {
        return new ImmutableSecureValueErrorTranslationFiles(type, text);
    }

    public static ImmutableSecureValueErrorTranslationFiles copyOf(SecureValueErrorTranslationFiles instance) {
        if (instance instanceof ImmutableSecureValueErrorTranslationFiles) {
            return (ImmutableSecureValueErrorTranslationFiles)instance;
        }
        return ImmutableSecureValueErrorTranslationFiles.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private List<ByteBuf> fileHash_value = null;
        private int identifier;
        private SecureValueType type;
        private String text;

        private Builder() {
        }

        public final Builder from(SecureValueError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureValueErrorTranslationFiles instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureValueError instance;
            long bits = 0L;
            if (object instanceof SecureValueError) {
                instance = (SecureValueError)object;
                if ((bits & 4L) == 0L) {
                    this.type(instance.type());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecureValueErrorTranslationFiles) {
                instance = (SecureValueErrorTranslationFiles)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fileHash(instance.fileHash());
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.type(instance.type());
                    bits |= 4L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder addFileHash(ByteBuf value) {
            this.fileHash_getOrCreate().add(TlEncodingUtil.copyAsUnpooled((ByteBuf)value));
            return this;
        }

        public Builder addAllFileHash(Iterable<? extends ByteBuf> value) {
            this.fileHash_getOrCreate().addAll(StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder addAllFileHash(ByteBuf ... value) {
            this.fileHash_getOrCreate().addAll(Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder fileHash(Iterable<? extends ByteBuf> value) {
            this.fileHash_value = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public Builder fileHash(ByteBuf ... value) {
            this.fileHash_value = Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSecureValueErrorTranslationFiles build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecureValueErrorTranslationFiles(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build SecureValueErrorTranslationFiles, some of required attributes are not set " + attributes;
        }

        private List<ByteBuf> fileHash_build() {
            return TlEncodingUtil.unmodifiableList(this.fileHash_value);
        }

        private List<ByteBuf> fileHash_getOrCreate() {
            if (this.fileHash_value == null) {
                this.fileHash_value = new ArrayList<ByteBuf>();
            }
            return this.fileHash_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecureValueErrorTranslationFiles.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SecureValueErrorTranslationFiles, attribute initializers form cycle " + attributes;
        }
    }
}

