/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SecureValueHash;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSecureValueHash
implements SecureValueHash {
    private final int identifier;
    private final SecureValueType type;
    private final ByteBuf hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSecureValueHash(SecureValueType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.hash = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureValueHash(Builder builder) {
        this.type = builder.type;
        this.hash = builder.hash_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableSecureValueHash(int identifier, SecureValueType type, ByteBuf hash) {
        this.identifier = identifier;
        this.type = type;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SecureValueHash.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    @Override
    public ByteBuf hash() {
        return this.hash.duplicate();
    }

    public final ImmutableSecureValueHash withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSecureValueHash(value, this.type, this.hash);
    }

    public final ImmutableSecureValueHash withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableSecureValueHash(this.identifier, newValue, this.hash);
    }

    public ImmutableSecureValueHash withHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.hash == newValue) {
            return this;
        }
        return new ImmutableSecureValueHash(this.identifier, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecureValueHash && this.equalTo(0, (ImmutableSecureValueHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableSecureValueHash another) {
        return this.identifier == another.identifier && this.type.equals((Object)another.type) && this.hash().equals((Object)another.hash());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.hash().hashCode();
        return h;
    }

    public String toString() {
        return "SecureValueHash{identifier=" + this.identifier + ", type=" + this.type + ", hash=" + ByteBufUtil.hexDump((ByteBuf)this.hash) + "}";
    }

    public static ImmutableSecureValueHash of(SecureValueType type) {
        return new ImmutableSecureValueHash(type);
    }

    public static ImmutableSecureValueHash copyOf(SecureValueHash instance) {
        if (instance instanceof ImmutableSecureValueHash) {
            return (ImmutableSecureValueHash)instance;
        }
        return ImmutableSecureValueHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf hash_value = null;
        private int identifier;
        private SecureValueType type;

        private Builder() {
        }

        public final Builder from(SecureValueHash instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureValueHash instance;
            long bits = 0L;
            if (object instanceof SecureValueHash) {
                instance = (SecureValueHash)object;
                this.type(instance.type());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder hash(ByteBuf value) {
            this.hash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableSecureValueHash build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecureValueHash(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build SecureValueHash, some of required attributes are not set " + attributes;
        }

        private ByteBuf hash_build() {
            return Objects.requireNonNull(this.hash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSecureValueHash.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build SecureValueHash, attribute initializers form cycle " + attributes;
        }
    }
}

