/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageEmojiInteraction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageEmojiInteraction
implements SendMessageEmojiInteraction {
    private final int identifier;
    private final String emoticon;
    private final int msgId;
    private final DataJSON interaction;

    private ImmutableSendMessageEmojiInteraction(String emoticon, int msgId, DataJSON interaction) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.msgId = msgId;
        this.interaction = Objects.requireNonNull(interaction, "interaction");
        this.identifier = SendMessageEmojiInteraction.super.identifier();
    }

    private ImmutableSendMessageEmojiInteraction(Builder builder) {
        this.emoticon = builder.emoticon;
        this.msgId = builder.msgId;
        this.interaction = builder.interaction;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageEmojiInteraction.super.identifier();
    }

    private ImmutableSendMessageEmojiInteraction(int identifier, String emoticon, int msgId, DataJSON interaction) {
        this.identifier = identifier;
        this.emoticon = emoticon;
        this.msgId = msgId;
        this.interaction = interaction;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public DataJSON interaction() {
        return this.interaction;
    }

    public final ImmutableSendMessageEmojiInteraction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendMessageEmojiInteraction(value, this.emoticon, this.msgId, this.interaction);
    }

    public final ImmutableSendMessageEmojiInteraction withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableSendMessageEmojiInteraction(this.identifier, newValue, this.msgId, this.interaction);
    }

    public final ImmutableSendMessageEmojiInteraction withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableSendMessageEmojiInteraction(this.identifier, this.emoticon, value, this.interaction);
    }

    public final ImmutableSendMessageEmojiInteraction withInteraction(DataJSON value) {
        if (this.interaction == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "interaction");
        return new ImmutableSendMessageEmojiInteraction(this.identifier, this.emoticon, this.msgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageEmojiInteraction && this.equalTo(0, (ImmutableSendMessageEmojiInteraction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageEmojiInteraction another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon) && this.msgId == another.msgId && this.interaction.equals(another.interaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.interaction.hashCode();
        return h;
    }

    public String toString() {
        return "SendMessageEmojiInteraction{identifier=" + this.identifier + ", emoticon=" + this.emoticon + ", msgId=" + this.msgId + ", interaction=" + this.interaction + "}";
    }

    public static ImmutableSendMessageEmojiInteraction of(String emoticon, int msgId, DataJSON interaction) {
        return new ImmutableSendMessageEmojiInteraction(emoticon, msgId, interaction);
    }

    public static ImmutableSendMessageEmojiInteraction copyOf(SendMessageEmojiInteraction instance) {
        if (instance instanceof ImmutableSendMessageEmojiInteraction) {
            return (ImmutableSendMessageEmojiInteraction)instance;
        }
        return ImmutableSendMessageEmojiInteraction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_INTERACTION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String emoticon;
        private int msgId;
        private DataJSON interaction;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageEmojiInteraction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageEmojiInteraction) {
                instance = (SendMessageEmojiInteraction)object;
                this.interaction(instance.interaction());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.emoticon(instance.emoticon());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder interaction(DataJSON interaction) {
            this.interaction = Objects.requireNonNull(interaction, "interaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSendMessageEmojiInteraction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendMessageEmojiInteraction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("interaction");
            }
            return "Cannot build SendMessageEmojiInteraction, some of required attributes are not set " + attributes;
        }
    }
}

