/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageEmojiInteractionSeen;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageEmojiInteractionSeen
implements SendMessageEmojiInteractionSeen {
    private final int identifier;
    private final String emoticon;

    private ImmutableSendMessageEmojiInteractionSeen(String emoticon) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.identifier = SendMessageEmojiInteractionSeen.super.identifier();
    }

    private ImmutableSendMessageEmojiInteractionSeen(Builder builder) {
        this.emoticon = builder.emoticon;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageEmojiInteractionSeen.super.identifier();
    }

    private ImmutableSendMessageEmojiInteractionSeen(int identifier, String emoticon) {
        this.identifier = identifier;
        this.emoticon = emoticon;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    public final ImmutableSendMessageEmojiInteractionSeen withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendMessageEmojiInteractionSeen(value, this.emoticon);
    }

    public final ImmutableSendMessageEmojiInteractionSeen withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableSendMessageEmojiInteractionSeen(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageEmojiInteractionSeen && this.equalTo(0, (ImmutableSendMessageEmojiInteractionSeen)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageEmojiInteractionSeen another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        return h;
    }

    public String toString() {
        return "SendMessageEmojiInteractionSeen{identifier=" + this.identifier + ", emoticon=" + this.emoticon + "}";
    }

    public static ImmutableSendMessageEmojiInteractionSeen of(String emoticon) {
        return new ImmutableSendMessageEmojiInteractionSeen(emoticon);
    }

    public static ImmutableSendMessageEmojiInteractionSeen copyOf(SendMessageEmojiInteractionSeen instance) {
        if (instance instanceof ImmutableSendMessageEmojiInteractionSeen) {
            return (ImmutableSendMessageEmojiInteractionSeen)instance;
        }
        return ImmutableSendMessageEmojiInteractionSeen.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String emoticon;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageEmojiInteractionSeen instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageEmojiInteractionSeen) {
                instance = (SendMessageEmojiInteractionSeen)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.emoticon(instance.emoticon());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSendMessageEmojiInteractionSeen build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendMessageEmojiInteractionSeen(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build SendMessageEmojiInteractionSeen, some of required attributes are not set " + attributes;
        }
    }
}

