/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageGamePlayAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageGamePlayAction
implements SendMessageGamePlayAction {
    private final int identifier;
    private static final ImmutableSendMessageGamePlayAction INSTANCE = ImmutableSendMessageGamePlayAction.validate(new ImmutableSendMessageGamePlayAction());

    private ImmutableSendMessageGamePlayAction() {
        this.identifier = SendMessageGamePlayAction.super.identifier();
    }

    private ImmutableSendMessageGamePlayAction(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageGamePlayAction.super.identifier();
    }

    private ImmutableSendMessageGamePlayAction(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSendMessageGamePlayAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSendMessageGamePlayAction.validate(new ImmutableSendMessageGamePlayAction(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageGamePlayAction && this.equalTo(0, (ImmutableSendMessageGamePlayAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageGamePlayAction another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SendMessageGamePlayAction{identifier=" + this.identifier + "}";
    }

    public static ImmutableSendMessageGamePlayAction of() {
        return INSTANCE;
    }

    private static ImmutableSendMessageGamePlayAction validate(ImmutableSendMessageGamePlayAction instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSendMessageGamePlayAction copyOf(SendMessageGamePlayAction instance) {
        if (instance instanceof ImmutableSendMessageGamePlayAction) {
            return (ImmutableSendMessageGamePlayAction)instance;
        }
        return ImmutableSendMessageGamePlayAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageGamePlayAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageGamePlayAction) {
                instance = (SendMessageGamePlayAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSendMessageGamePlayAction build() {
            return ImmutableSendMessageGamePlayAction.validate(new ImmutableSendMessageGamePlayAction(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

