/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageRecordAudioAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageRecordAudioAction
implements SendMessageRecordAudioAction {
    private final int identifier;
    private static final ImmutableSendMessageRecordAudioAction INSTANCE = ImmutableSendMessageRecordAudioAction.validate(new ImmutableSendMessageRecordAudioAction());

    private ImmutableSendMessageRecordAudioAction() {
        this.identifier = SendMessageRecordAudioAction.super.identifier();
    }

    private ImmutableSendMessageRecordAudioAction(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageRecordAudioAction.super.identifier();
    }

    private ImmutableSendMessageRecordAudioAction(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSendMessageRecordAudioAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSendMessageRecordAudioAction.validate(new ImmutableSendMessageRecordAudioAction(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageRecordAudioAction && this.equalTo(0, (ImmutableSendMessageRecordAudioAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageRecordAudioAction another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SendMessageRecordAudioAction{identifier=" + this.identifier + "}";
    }

    public static ImmutableSendMessageRecordAudioAction of() {
        return INSTANCE;
    }

    private static ImmutableSendMessageRecordAudioAction validate(ImmutableSendMessageRecordAudioAction instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSendMessageRecordAudioAction copyOf(SendMessageRecordAudioAction instance) {
        if (instance instanceof ImmutableSendMessageRecordAudioAction) {
            return (ImmutableSendMessageRecordAudioAction)instance;
        }
        return ImmutableSendMessageRecordAudioAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageRecordAudioAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageRecordAudioAction) {
                instance = (SendMessageRecordAudioAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSendMessageRecordAudioAction build() {
            return ImmutableSendMessageRecordAudioAction.validate(new ImmutableSendMessageRecordAudioAction(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

