/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageRecordRoundAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageRecordRoundAction
implements SendMessageRecordRoundAction {
    private final int identifier;
    private static final ImmutableSendMessageRecordRoundAction INSTANCE = ImmutableSendMessageRecordRoundAction.validate(new ImmutableSendMessageRecordRoundAction());

    private ImmutableSendMessageRecordRoundAction() {
        this.identifier = SendMessageRecordRoundAction.super.identifier();
    }

    private ImmutableSendMessageRecordRoundAction(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageRecordRoundAction.super.identifier();
    }

    private ImmutableSendMessageRecordRoundAction(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSendMessageRecordRoundAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSendMessageRecordRoundAction.validate(new ImmutableSendMessageRecordRoundAction(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageRecordRoundAction && this.equalTo(0, (ImmutableSendMessageRecordRoundAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageRecordRoundAction another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SendMessageRecordRoundAction{identifier=" + this.identifier + "}";
    }

    public static ImmutableSendMessageRecordRoundAction of() {
        return INSTANCE;
    }

    private static ImmutableSendMessageRecordRoundAction validate(ImmutableSendMessageRecordRoundAction instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSendMessageRecordRoundAction copyOf(SendMessageRecordRoundAction instance) {
        if (instance instanceof ImmutableSendMessageRecordRoundAction) {
            return (ImmutableSendMessageRecordRoundAction)instance;
        }
        return ImmutableSendMessageRecordRoundAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageRecordRoundAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageRecordRoundAction) {
                instance = (SendMessageRecordRoundAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSendMessageRecordRoundAction build() {
            return ImmutableSendMessageRecordRoundAction.validate(new ImmutableSendMessageRecordRoundAction(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

