/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageRecordVideoAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageRecordVideoAction
implements SendMessageRecordVideoAction {
    private final int identifier;
    private static final ImmutableSendMessageRecordVideoAction INSTANCE = ImmutableSendMessageRecordVideoAction.validate(new ImmutableSendMessageRecordVideoAction());

    private ImmutableSendMessageRecordVideoAction() {
        this.identifier = SendMessageRecordVideoAction.super.identifier();
    }

    private ImmutableSendMessageRecordVideoAction(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageRecordVideoAction.super.identifier();
    }

    private ImmutableSendMessageRecordVideoAction(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSendMessageRecordVideoAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSendMessageRecordVideoAction.validate(new ImmutableSendMessageRecordVideoAction(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageRecordVideoAction && this.equalTo(0, (ImmutableSendMessageRecordVideoAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageRecordVideoAction another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SendMessageRecordVideoAction{identifier=" + this.identifier + "}";
    }

    public static ImmutableSendMessageRecordVideoAction of() {
        return INSTANCE;
    }

    private static ImmutableSendMessageRecordVideoAction validate(ImmutableSendMessageRecordVideoAction instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSendMessageRecordVideoAction copyOf(SendMessageRecordVideoAction instance) {
        if (instance instanceof ImmutableSendMessageRecordVideoAction) {
            return (ImmutableSendMessageRecordVideoAction)instance;
        }
        return ImmutableSendMessageRecordVideoAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageRecordVideoAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageRecordVideoAction) {
                instance = (SendMessageRecordVideoAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSendMessageRecordVideoAction build() {
            return ImmutableSendMessageRecordVideoAction.validate(new ImmutableSendMessageRecordVideoAction(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

