/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageTypingAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageTypingAction
implements SendMessageTypingAction {
    private final int identifier;
    private static final ImmutableSendMessageTypingAction INSTANCE = ImmutableSendMessageTypingAction.validate(new ImmutableSendMessageTypingAction());

    private ImmutableSendMessageTypingAction() {
        this.identifier = SendMessageTypingAction.super.identifier();
    }

    private ImmutableSendMessageTypingAction(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageTypingAction.super.identifier();
    }

    private ImmutableSendMessageTypingAction(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSendMessageTypingAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSendMessageTypingAction.validate(new ImmutableSendMessageTypingAction(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageTypingAction && this.equalTo(0, (ImmutableSendMessageTypingAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageTypingAction another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SendMessageTypingAction{identifier=" + this.identifier + "}";
    }

    public static ImmutableSendMessageTypingAction of() {
        return INSTANCE;
    }

    private static ImmutableSendMessageTypingAction validate(ImmutableSendMessageTypingAction instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSendMessageTypingAction copyOf(SendMessageTypingAction instance) {
        if (instance instanceof ImmutableSendMessageTypingAction) {
            return (ImmutableSendMessageTypingAction)instance;
        }
        return ImmutableSendMessageTypingAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SendMessageTypingAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageTypingAction) {
                instance = (SendMessageTypingAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSendMessageTypingAction build() {
            return ImmutableSendMessageTypingAction.validate(new ImmutableSendMessageTypingAction(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

