/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SendMessageUploadDocumentAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSendMessageUploadDocumentAction
implements SendMessageUploadDocumentAction {
    private final int identifier;
    private final int progress;

    private ImmutableSendMessageUploadDocumentAction(int progress) {
        this.progress = progress;
        this.identifier = SendMessageUploadDocumentAction.super.identifier();
    }

    private ImmutableSendMessageUploadDocumentAction(Builder builder) {
        this.progress = builder.progress;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendMessageUploadDocumentAction.super.identifier();
    }

    private ImmutableSendMessageUploadDocumentAction(int identifier, int progress) {
        this.identifier = identifier;
        this.progress = progress;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int progress() {
        return this.progress;
    }

    public final ImmutableSendMessageUploadDocumentAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendMessageUploadDocumentAction(value, this.progress);
    }

    public final ImmutableSendMessageUploadDocumentAction withProgress(int value) {
        if (this.progress == value) {
            return this;
        }
        return new ImmutableSendMessageUploadDocumentAction(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendMessageUploadDocumentAction && this.equalTo(0, (ImmutableSendMessageUploadDocumentAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendMessageUploadDocumentAction another) {
        return this.identifier == another.identifier && this.progress == another.progress;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.progress;
        return h;
    }

    public String toString() {
        return "SendMessageUploadDocumentAction{identifier=" + this.identifier + ", progress=" + this.progress + "}";
    }

    public static ImmutableSendMessageUploadDocumentAction of(int progress) {
        return new ImmutableSendMessageUploadDocumentAction(progress);
    }

    public static ImmutableSendMessageUploadDocumentAction copyOf(SendMessageUploadDocumentAction instance) {
        if (instance instanceof ImmutableSendMessageUploadDocumentAction) {
            return (ImmutableSendMessageUploadDocumentAction)instance;
        }
        return ImmutableSendMessageUploadDocumentAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PROGRESS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int progress;

        private Builder() {
        }

        public final Builder from(SendMessageUploadDocumentAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageUploadDocumentAction) {
                instance = (SendMessageUploadDocumentAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.progress(instance.progress());
            }
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder progress(int progress) {
            this.progress = progress;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSendMessageUploadDocumentAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendMessageUploadDocumentAction(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("progress");
            }
            return "Cannot build SendMessageUploadDocumentAction, some of required attributes are not set " + attributes;
        }
    }
}

