/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.LabeledPrice;
import telegram4j.tl.ShippingOption;
import telegram4j.tl.api.TlObject;

public final class ImmutableShippingOption
implements ShippingOption {
    private final int identifier;
    private final String id;
    private final String title;
    private final List<LabeledPrice> prices;

    private ImmutableShippingOption(String id, String title) {
        this.id = Objects.requireNonNull(id, "id");
        this.title = Objects.requireNonNull(title, "title");
        this.prices = Collections.emptyList();
        this.identifier = ShippingOption.super.identifier();
    }

    private ImmutableShippingOption(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.prices = ImmutableShippingOption.createUnmodifiableList(true, builder.prices);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ShippingOption.super.identifier();
    }

    private ImmutableShippingOption(int identifier, String id, String title, List<LabeledPrice> prices) {
        this.identifier = identifier;
        this.id = id;
        this.title = title;
        this.prices = prices;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public List<LabeledPrice> prices() {
        return this.prices;
    }

    public final ImmutableShippingOption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableShippingOption(value, this.id, this.title, this.prices);
    }

    public final ImmutableShippingOption withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableShippingOption(this.identifier, newValue, this.title, this.prices);
    }

    public final ImmutableShippingOption withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableShippingOption(this.identifier, this.id, newValue, this.prices);
    }

    public final ImmutableShippingOption withPrices(LabeledPrice ... elements) {
        List<LabeledPrice> newValue = ImmutableShippingOption.createUnmodifiableList(false, ImmutableShippingOption.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableShippingOption(this.identifier, this.id, this.title, newValue);
    }

    public final ImmutableShippingOption withPrices(Iterable<? extends LabeledPrice> elements) {
        if (this.prices == elements) {
            return this;
        }
        List<LabeledPrice> newValue = ImmutableShippingOption.createUnmodifiableList(false, ImmutableShippingOption.createSafeList(elements, true, false));
        return new ImmutableShippingOption(this.identifier, this.id, this.title, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShippingOption && this.equalTo(0, (ImmutableShippingOption)another);
    }

    private boolean equalTo(int synthetic, ImmutableShippingOption another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.title.equals(another.title) && this.prices.equals(another.prices);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.prices.hashCode();
        return h;
    }

    public String toString() {
        return "ShippingOption{identifier=" + this.identifier + ", id=" + this.id + ", title=" + this.title + ", prices=" + this.prices + "}";
    }

    public static ImmutableShippingOption of(String id, String title) {
        return new ImmutableShippingOption(id, title);
    }

    public static ImmutableShippingOption copyOf(ShippingOption instance) {
        if (instance instanceof ImmutableShippingOption) {
            return (ImmutableShippingOption)instance;
        }
        return ImmutableShippingOption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String id;
        private String title;
        private List<LabeledPrice> prices = new ArrayList<LabeledPrice>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ShippingOption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ShippingOption) {
                instance = (ShippingOption)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.title(instance.title());
                this.addAllPrices(instance.prices());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPrice(LabeledPrice element) {
            this.prices.add(Objects.requireNonNull(element, "prices element"));
            return this;
        }

        public final Builder addPrices(LabeledPrice ... elements) {
            for (LabeledPrice element : elements) {
                this.prices.add(Objects.requireNonNull(element, "prices element"));
            }
            return this;
        }

        public final Builder prices(Iterable<? extends LabeledPrice> elements) {
            this.prices.clear();
            return this.addAllPrices(elements);
        }

        public final Builder addAllPrices(Iterable<? extends LabeledPrice> elements) {
            for (LabeledPrice labeledPrice : elements) {
                this.prices.add(Objects.requireNonNull(labeledPrice, "prices element"));
            }
            return this;
        }

        public ImmutableShippingOption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableShippingOption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build ShippingOption, some of required attributes are not set " + attributes;
        }
    }
}

