/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.SpeakingInGroupCallAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableSpeakingInGroupCallAction
implements SpeakingInGroupCallAction {
    private final int identifier;
    private static final ImmutableSpeakingInGroupCallAction INSTANCE = ImmutableSpeakingInGroupCallAction.validate(new ImmutableSpeakingInGroupCallAction());

    private ImmutableSpeakingInGroupCallAction() {
        this.identifier = SpeakingInGroupCallAction.super.identifier();
    }

    private ImmutableSpeakingInGroupCallAction(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : SpeakingInGroupCallAction.super.identifier();
    }

    private ImmutableSpeakingInGroupCallAction(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableSpeakingInGroupCallAction withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSpeakingInGroupCallAction.validate(new ImmutableSpeakingInGroupCallAction(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpeakingInGroupCallAction && this.equalTo(0, (ImmutableSpeakingInGroupCallAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableSpeakingInGroupCallAction another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "SpeakingInGroupCallAction{identifier=" + this.identifier + "}";
    }

    public static ImmutableSpeakingInGroupCallAction of() {
        return INSTANCE;
    }

    private static ImmutableSpeakingInGroupCallAction validate(ImmutableSpeakingInGroupCallAction instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSpeakingInGroupCallAction copyOf(SpeakingInGroupCallAction instance) {
        if (instance instanceof ImmutableSpeakingInGroupCallAction) {
            return (ImmutableSpeakingInGroupCallAction)instance;
        }
        return ImmutableSpeakingInGroupCallAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(SendMessageAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SpeakingInGroupCallAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendMessageAction instance;
            long bits = 0L;
            if (object instanceof SendMessageAction) {
                instance = (SendMessageAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SpeakingInGroupCallAction) {
                instance = (SpeakingInGroupCallAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableSpeakingInGroupCallAction build() {
            return ImmutableSpeakingInGroupCallAction.validate(new ImmutableSpeakingInGroupCallAction(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

