/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChatInvite;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.Peer;
import telegram4j.tl.SponsoredMessage;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableSponsoredMessage
implements SponsoredMessage {
    private final int identifier;
    private final int flags;
    private final boolean recommended;
    private final ByteBuf randomId;
    @Nullable
    private final Peer fromId;
    @Nullable
    private final ChatInvite chatInvite;
    @Nullable
    private final String chatInviteHash;
    @Nullable
    private final Integer channelPost;
    @Nullable
    private final String startParam;
    private final String message;
    @Nullable
    private final List<MessageEntity> entities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSponsoredMessage(String message) {
        this.message = Objects.requireNonNull(message, "message");
        this.randomId = null;
        this.fromId = null;
        this.chatInvite = null;
        this.chatInviteHash = null;
        this.channelPost = null;
        this.startParam = null;
        this.entities = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.recommended = this.initShim.recommended();
        this.initShim = null;
    }

    private ImmutableSponsoredMessage(Builder builder) {
        this.randomId = builder.randomId_build();
        this.fromId = builder.fromId;
        this.chatInvite = builder.chatInvite;
        this.chatInviteHash = builder.chatInviteHash;
        this.channelPost = builder.channelPost;
        this.startParam = builder.startParam;
        this.message = builder.message;
        List<MessageEntity> list = this.entities = builder.entities == null ? null : ImmutableSponsoredMessage.createUnmodifiableList(true, builder.entities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.recommendedIsSet()) {
            this.initShim.recommended(builder.recommended);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.recommended = this.initShim.recommended();
        this.initShim = null;
    }

    private ImmutableSponsoredMessage(int identifier, int flags, boolean recommended, ByteBuf randomId, @Nullable Peer fromId, @Nullable ChatInvite chatInvite, @Nullable String chatInviteHash, @Nullable Integer channelPost, @Nullable String startParam, String message, @Nullable List<MessageEntity> entities) {
        this.identifier = identifier;
        this.flags = flags;
        this.recommended = recommended;
        this.randomId = randomId;
        this.fromId = fromId;
        this.chatInvite = chatInvite;
        this.chatInviteHash = chatInviteHash;
        this.channelPost = channelPost;
        this.startParam = startParam;
        this.message = message;
        this.entities = entities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SponsoredMessage.super.identifier();
    }

    private int flagsInitialize() {
        return SponsoredMessage.super.flags();
    }

    private boolean recommendedInitialize() {
        return SponsoredMessage.super.recommended();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean recommended() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recommended() : this.recommended;
    }

    @Override
    public ByteBuf randomId() {
        return this.randomId.duplicate();
    }

    @Override
    @Nullable
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    @Nullable
    public ChatInvite chatInvite() {
        return this.chatInvite;
    }

    @Override
    @Nullable
    public String chatInviteHash() {
        return this.chatInviteHash;
    }

    @Override
    @Nullable
    public Integer channelPost() {
        return this.channelPost;
    }

    @Override
    @Nullable
    public String startParam() {
        return this.startParam;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    public final ImmutableSponsoredMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSponsoredMessage(value, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, value, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withRecommended(boolean value) {
        if (this.recommended == value) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, value, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, this.entities);
    }

    public ImmutableSponsoredMessage withRandomId(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.randomId == newValue) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, newValue, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withFromId(@Nullable Peer value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, value, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withChatInvite(@Nullable ChatInvite value) {
        if (this.chatInvite == value) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, value, this.chatInviteHash, this.channelPost, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withChatInviteHash(@Nullable String value) {
        if (Objects.equals(this.chatInviteHash, value)) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, value, this.channelPost, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withChannelPost(@Nullable Integer value) {
        if (Objects.equals(this.channelPost, value)) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, value, this.startParam, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withStartParam(@Nullable String value) {
        if (Objects.equals(this.startParam, value)) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, value, this.message, this.entities);
    }

    public final ImmutableSponsoredMessage withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, newValue, this.entities);
    }

    public final ImmutableSponsoredMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, null);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableSponsoredMessage.createUnmodifiableList(false, ImmutableSponsoredMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, newValue);
    }

    public final ImmutableSponsoredMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableSponsoredMessage.createUnmodifiableList(false, ImmutableSponsoredMessage.createSafeList(elements, true, false));
        return new ImmutableSponsoredMessage(this.identifier, this.flags, this.recommended, this.randomId, this.fromId, this.chatInvite, this.chatInviteHash, this.channelPost, this.startParam, this.message, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSponsoredMessage && this.equalTo(0, (ImmutableSponsoredMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableSponsoredMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.recommended == another.recommended && this.randomId().equals((Object)another.randomId()) && Objects.equals(this.fromId, another.fromId) && Objects.equals(this.chatInvite, another.chatInvite) && Objects.equals(this.chatInviteHash, another.chatInviteHash) && Objects.equals(this.channelPost, another.channelPost) && Objects.equals(this.startParam, another.startParam) && this.message.equals(another.message) && Objects.equals(this.entities, another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.recommended);
        h += (h << 5) + this.randomId().hashCode();
        h += (h << 5) + Objects.hashCode(this.fromId);
        h += (h << 5) + Objects.hashCode(this.chatInvite);
        h += (h << 5) + Objects.hashCode(this.chatInviteHash);
        h += (h << 5) + Objects.hashCode(this.channelPost);
        h += (h << 5) + Objects.hashCode(this.startParam);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.entities);
        return h;
    }

    public String toString() {
        return "SponsoredMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", recommended=" + this.recommended + ", randomId=" + ByteBufUtil.hexDump((ByteBuf)this.randomId) + ", fromId=" + this.fromId + ", chatInvite=" + this.chatInvite + ", chatInviteHash=" + this.chatInviteHash + ", channelPost=" + this.channelPost + ", startParam=" + this.startParam + ", message=" + this.message + ", entities=" + this.entities + "}";
    }

    public static ImmutableSponsoredMessage of(String message) {
        return new ImmutableSponsoredMessage(message);
    }

    public static ImmutableSponsoredMessage copyOf(SponsoredMessage instance) {
        if (instance instanceof ImmutableSponsoredMessage) {
            return (ImmutableSponsoredMessage)instance;
        }
        return ImmutableSponsoredMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_RECOMMENDED = 4L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf randomId_value = null;
        private int identifier;
        private int flags;
        private boolean recommended;
        private Peer fromId;
        private ChatInvite chatInvite;
        private String chatInviteHash;
        private Integer channelPost;
        private String startParam;
        private String message;
        private List<MessageEntity> entities = null;

        private Builder() {
        }

        public final Builder from(SponsoredMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SponsoredMessage instance;
            long bits = 0L;
            if (object instanceof SponsoredMessage) {
                ChatInvite chatInviteValue;
                Integer channelPostValue;
                List<MessageEntity> entitiesValue;
                instance = (SponsoredMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                String startParamValue = instance.startParam();
                if (startParamValue != null) {
                    this.startParam(startParamValue);
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                if ((channelPostValue = instance.channelPost()) != null) {
                    this.channelPost(channelPostValue);
                }
                this.flags(instance.flags());
                String chatInviteHashValue = instance.chatInviteHash();
                if (chatInviteHashValue != null) {
                    this.chatInviteHash(chatInviteHashValue);
                }
                this.message(instance.message());
                Peer fromIdValue = instance.fromId();
                if (fromIdValue != null) {
                    this.fromId(fromIdValue);
                }
                if ((chatInviteValue = instance.chatInvite()) != null) {
                    this.chatInvite(chatInviteValue);
                }
                this.recommended(instance.recommended());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder recommended(boolean recommended) {
            this.recommended = recommended;
            this.optBits |= 4L;
            return this;
        }

        public Builder randomId(ByteBuf value) {
            this.randomId_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder fromId(@Nullable Peer fromId) {
            this.fromId = fromId;
            return this;
        }

        public final Builder chatInvite(@Nullable ChatInvite chatInvite) {
            this.chatInvite = chatInvite;
            return this;
        }

        public final Builder chatInviteHash(@Nullable String chatInviteHash) {
            this.chatInviteHash = chatInviteHash;
            return this;
        }

        public final Builder channelPost(@Nullable Integer channelPost) {
            this.channelPost = channelPost;
            return this;
        }

        public final Builder startParam(@Nullable String startParam) {
            this.startParam = startParam;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public ImmutableSponsoredMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSponsoredMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean recommendedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build SponsoredMessage, some of required attributes are not set " + attributes;
        }

        private ByteBuf randomId_build() {
            return Objects.requireNonNull(this.randomId_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte recommendedBuildStage = 0;
        private boolean recommended;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSponsoredMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSponsoredMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean recommended() {
            if (this.recommendedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recommendedBuildStage == 0) {
                this.recommendedBuildStage = (byte)-1;
                this.recommended = ImmutableSponsoredMessage.this.recommendedInitialize();
                this.recommendedBuildStage = 1;
            }
            return this.recommended;
        }

        void recommended(boolean recommended) {
            this.recommended = recommended;
            this.recommendedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.recommendedBuildStage == -1) {
                attributes.add("recommended");
            }
            return "Cannot build SponsoredMessage, attribute initializers form cycle " + attributes;
        }
    }
}

