/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsAbsValueAndPrev;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsAbsValueAndPrev
implements StatsAbsValueAndPrev {
    private final int identifier;
    private final double current;
    private final double previous;

    private ImmutableStatsAbsValueAndPrev(double current, double previous) {
        this.current = current;
        this.previous = previous;
        this.identifier = StatsAbsValueAndPrev.super.identifier();
    }

    private ImmutableStatsAbsValueAndPrev(Builder builder) {
        this.current = builder.current;
        this.previous = builder.previous;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsAbsValueAndPrev.super.identifier();
    }

    private ImmutableStatsAbsValueAndPrev(int identifier, double current, double previous) {
        this.identifier = identifier;
        this.current = current;
        this.previous = previous;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public double current() {
        return this.current;
    }

    @Override
    public double previous() {
        return this.previous;
    }

    public final ImmutableStatsAbsValueAndPrev withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsAbsValueAndPrev(value, this.current, this.previous);
    }

    public final ImmutableStatsAbsValueAndPrev withCurrent(double value) {
        if (Double.doubleToLongBits(this.current) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStatsAbsValueAndPrev(this.identifier, value, this.previous);
    }

    public final ImmutableStatsAbsValueAndPrev withPrevious(double value) {
        if (Double.doubleToLongBits(this.previous) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStatsAbsValueAndPrev(this.identifier, this.current, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsAbsValueAndPrev && this.equalTo(0, (ImmutableStatsAbsValueAndPrev)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsAbsValueAndPrev another) {
        return this.identifier == another.identifier && Double.doubleToLongBits(this.current) == Double.doubleToLongBits(another.current) && Double.doubleToLongBits(this.previous) == Double.doubleToLongBits(another.previous);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Double.hashCode(this.current);
        h += (h << 5) + Double.hashCode(this.previous);
        return h;
    }

    public String toString() {
        return "StatsAbsValueAndPrev{identifier=" + this.identifier + ", current=" + this.current + ", previous=" + this.previous + "}";
    }

    public static ImmutableStatsAbsValueAndPrev of(double current, double previous) {
        return new ImmutableStatsAbsValueAndPrev(current, previous);
    }

    public static ImmutableStatsAbsValueAndPrev copyOf(StatsAbsValueAndPrev instance) {
        if (instance instanceof ImmutableStatsAbsValueAndPrev) {
            return (ImmutableStatsAbsValueAndPrev)instance;
        }
        return ImmutableStatsAbsValueAndPrev.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CURRENT = 1L;
        private static final long INIT_BIT_PREVIOUS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private double current;
        private double previous;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StatsAbsValueAndPrev instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StatsAbsValueAndPrev) {
                instance = (StatsAbsValueAndPrev)object;
                this.previous(instance.previous());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.current(instance.current());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder current(double current) {
            this.current = current;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder previous(double previous) {
            this.previous = previous;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStatsAbsValueAndPrev build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsAbsValueAndPrev(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("current");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("previous");
            }
            return "Cannot build StatsAbsValueAndPrev, some of required attributes are not set " + attributes;
        }
    }
}

