/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsDateRangeDays;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsDateRangeDays
implements StatsDateRangeDays {
    private final int identifier;
    private final int minDate;
    private final int maxDate;

    private ImmutableStatsDateRangeDays(int minDate, int maxDate) {
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.identifier = StatsDateRangeDays.super.identifier();
    }

    private ImmutableStatsDateRangeDays(Builder builder) {
        this.minDate = builder.minDate;
        this.maxDate = builder.maxDate;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsDateRangeDays.super.identifier();
    }

    private ImmutableStatsDateRangeDays(int identifier, int minDate, int maxDate) {
        this.identifier = identifier;
        this.minDate = minDate;
        this.maxDate = maxDate;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int minDate() {
        return this.minDate;
    }

    @Override
    public int maxDate() {
        return this.maxDate;
    }

    public final ImmutableStatsDateRangeDays withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsDateRangeDays(value, this.minDate, this.maxDate);
    }

    public final ImmutableStatsDateRangeDays withMinDate(int value) {
        if (this.minDate == value) {
            return this;
        }
        return new ImmutableStatsDateRangeDays(this.identifier, value, this.maxDate);
    }

    public final ImmutableStatsDateRangeDays withMaxDate(int value) {
        if (this.maxDate == value) {
            return this;
        }
        return new ImmutableStatsDateRangeDays(this.identifier, this.minDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsDateRangeDays && this.equalTo(0, (ImmutableStatsDateRangeDays)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsDateRangeDays another) {
        return this.identifier == another.identifier && this.minDate == another.minDate && this.maxDate == another.maxDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.minDate;
        h += (h << 5) + this.maxDate;
        return h;
    }

    public String toString() {
        return "StatsDateRangeDays{identifier=" + this.identifier + ", minDate=" + this.minDate + ", maxDate=" + this.maxDate + "}";
    }

    public static ImmutableStatsDateRangeDays of(int minDate, int maxDate) {
        return new ImmutableStatsDateRangeDays(minDate, maxDate);
    }

    public static ImmutableStatsDateRangeDays copyOf(StatsDateRangeDays instance) {
        if (instance instanceof ImmutableStatsDateRangeDays) {
            return (ImmutableStatsDateRangeDays)instance;
        }
        return ImmutableStatsDateRangeDays.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MIN_DATE = 1L;
        private static final long INIT_BIT_MAX_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int minDate;
        private int maxDate;

        private Builder() {
        }

        public final Builder from(StatsDateRangeDays instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StatsDateRangeDays instance;
            long bits = 0L;
            if (object instanceof StatsDateRangeDays) {
                instance = (StatsDateRangeDays)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.minDate(instance.minDate());
                this.maxDate(instance.maxDate());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder minDate(int minDate) {
            this.minDate = minDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxDate(int maxDate) {
            this.maxDate = maxDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStatsDateRangeDays build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsDateRangeDays(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("minDate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxDate");
            }
            return "Cannot build StatsDateRangeDays, some of required attributes are not set " + attributes;
        }
    }
}

