/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsGraph;
import telegram4j.tl.StatsGraphAsync;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsGraphAsync
implements StatsGraphAsync {
    private final int identifier;
    private final String token;

    private ImmutableStatsGraphAsync(String token) {
        this.token = Objects.requireNonNull(token, "token");
        this.identifier = StatsGraphAsync.super.identifier();
    }

    private ImmutableStatsGraphAsync(Builder builder) {
        this.token = builder.token;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsGraphAsync.super.identifier();
    }

    private ImmutableStatsGraphAsync(int identifier, String token) {
        this.identifier = identifier;
        this.token = token;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String token() {
        return this.token;
    }

    public final ImmutableStatsGraphAsync withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsGraphAsync(value, this.token);
    }

    public final ImmutableStatsGraphAsync withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableStatsGraphAsync(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGraphAsync && this.equalTo(0, (ImmutableStatsGraphAsync)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsGraphAsync another) {
        return this.identifier == another.identifier && this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.token.hashCode();
        return h;
    }

    public String toString() {
        return "StatsGraphAsync{identifier=" + this.identifier + ", token=" + this.token + "}";
    }

    public static ImmutableStatsGraphAsync of(String token) {
        return new ImmutableStatsGraphAsync(token);
    }

    public static ImmutableStatsGraphAsync copyOf(StatsGraphAsync instance) {
        if (instance instanceof ImmutableStatsGraphAsync) {
            return (ImmutableStatsGraphAsync)instance;
        }
        return ImmutableStatsGraphAsync.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String token;

        private Builder() {
        }

        public final Builder from(StatsGraphAsync instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StatsGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StatsGraph instance;
            long bits = 0L;
            if (object instanceof StatsGraphAsync) {
                instance = (StatsGraphAsync)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.token(instance.token());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StatsGraph) {
                instance = (StatsGraph)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStatsGraphAsync build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGraphAsync(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build StatsGraphAsync, some of required attributes are not set " + attributes;
        }
    }
}

