/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsGraph;
import telegram4j.tl.StatsGraphError;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsGraphError
implements StatsGraphError {
    private final int identifier;
    private final String error;

    private ImmutableStatsGraphError(String error) {
        this.error = Objects.requireNonNull(error, "error");
        this.identifier = StatsGraphError.super.identifier();
    }

    private ImmutableStatsGraphError(Builder builder) {
        this.error = builder.error;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsGraphError.super.identifier();
    }

    private ImmutableStatsGraphError(int identifier, String error) {
        this.identifier = identifier;
        this.error = error;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String error() {
        return this.error;
    }

    public final ImmutableStatsGraphError withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsGraphError(value, this.error);
    }

    public final ImmutableStatsGraphError withError(String value) {
        String newValue = Objects.requireNonNull(value, "error");
        if (this.error.equals(newValue)) {
            return this;
        }
        return new ImmutableStatsGraphError(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGraphError && this.equalTo(0, (ImmutableStatsGraphError)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsGraphError another) {
        return this.identifier == another.identifier && this.error.equals(another.error);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.error.hashCode();
        return h;
    }

    public String toString() {
        return "StatsGraphError{identifier=" + this.identifier + ", error=" + this.error + "}";
    }

    public static ImmutableStatsGraphError of(String error) {
        return new ImmutableStatsGraphError(error);
    }

    public static ImmutableStatsGraphError copyOf(StatsGraphError instance) {
        if (instance instanceof ImmutableStatsGraphError) {
            return (ImmutableStatsGraphError)instance;
        }
        return ImmutableStatsGraphError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ERROR = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String error;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StatsGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StatsGraphError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StatsGraph) {
                instance = (StatsGraph)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StatsGraphError) {
                instance = (StatsGraphError)object;
                this.error(instance.error());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder error(String error) {
            this.error = Objects.requireNonNull(error, "error");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStatsGraphError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGraphError(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("error");
            }
            return "Cannot build StatsGraphError, some of required attributes are not set " + attributes;
        }
    }
}

