/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsGroupTopAdmin;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsGroupTopAdmin
implements StatsGroupTopAdmin {
    private final int identifier;
    private final long userId;
    private final int deleted;
    private final int kicked;
    private final int banned;

    private ImmutableStatsGroupTopAdmin(long userId, int deleted, int kicked, int banned) {
        this.userId = userId;
        this.deleted = deleted;
        this.kicked = kicked;
        this.banned = banned;
        this.identifier = StatsGroupTopAdmin.super.identifier();
    }

    private ImmutableStatsGroupTopAdmin(Builder builder) {
        this.userId = builder.userId;
        this.deleted = builder.deleted;
        this.kicked = builder.kicked;
        this.banned = builder.banned;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsGroupTopAdmin.super.identifier();
    }

    private ImmutableStatsGroupTopAdmin(int identifier, long userId, int deleted, int kicked, int banned) {
        this.identifier = identifier;
        this.userId = userId;
        this.deleted = deleted;
        this.kicked = kicked;
        this.banned = banned;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int deleted() {
        return this.deleted;
    }

    @Override
    public int kicked() {
        return this.kicked;
    }

    @Override
    public int banned() {
        return this.banned;
    }

    public final ImmutableStatsGroupTopAdmin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsGroupTopAdmin(value, this.userId, this.deleted, this.kicked, this.banned);
    }

    public final ImmutableStatsGroupTopAdmin withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableStatsGroupTopAdmin(this.identifier, value, this.deleted, this.kicked, this.banned);
    }

    public final ImmutableStatsGroupTopAdmin withDeleted(int value) {
        if (this.deleted == value) {
            return this;
        }
        return new ImmutableStatsGroupTopAdmin(this.identifier, this.userId, value, this.kicked, this.banned);
    }

    public final ImmutableStatsGroupTopAdmin withKicked(int value) {
        if (this.kicked == value) {
            return this;
        }
        return new ImmutableStatsGroupTopAdmin(this.identifier, this.userId, this.deleted, value, this.banned);
    }

    public final ImmutableStatsGroupTopAdmin withBanned(int value) {
        if (this.banned == value) {
            return this;
        }
        return new ImmutableStatsGroupTopAdmin(this.identifier, this.userId, this.deleted, this.kicked, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGroupTopAdmin && this.equalTo(0, (ImmutableStatsGroupTopAdmin)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsGroupTopAdmin another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.deleted == another.deleted && this.kicked == another.kicked && this.banned == another.banned;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.deleted;
        h += (h << 5) + this.kicked;
        h += (h << 5) + this.banned;
        return h;
    }

    public String toString() {
        return "StatsGroupTopAdmin{identifier=" + this.identifier + ", userId=" + this.userId + ", deleted=" + this.deleted + ", kicked=" + this.kicked + ", banned=" + this.banned + "}";
    }

    public static ImmutableStatsGroupTopAdmin of(long userId, int deleted, int kicked, int banned) {
        return new ImmutableStatsGroupTopAdmin(userId, deleted, kicked, banned);
    }

    public static ImmutableStatsGroupTopAdmin copyOf(StatsGroupTopAdmin instance) {
        if (instance instanceof ImmutableStatsGroupTopAdmin) {
            return (ImmutableStatsGroupTopAdmin)instance;
        }
        return ImmutableStatsGroupTopAdmin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DELETED = 2L;
        private static final long INIT_BIT_KICKED = 4L;
        private static final long INIT_BIT_BANNED = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long userId;
        private int deleted;
        private int kicked;
        private int banned;

        private Builder() {
        }

        public final Builder from(StatsGroupTopAdmin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StatsGroupTopAdmin instance;
            long bits = 0L;
            if (object instanceof StatsGroupTopAdmin) {
                instance = (StatsGroupTopAdmin)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.kicked(instance.kicked());
                this.deleted(instance.deleted());
                this.banned(instance.banned());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder deleted(int deleted) {
            this.deleted = deleted;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder kicked(int kicked) {
            this.kicked = kicked;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder banned(int banned) {
            this.banned = banned;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableStatsGroupTopAdmin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGroupTopAdmin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("deleted");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("kicked");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("banned");
            }
            return "Cannot build StatsGroupTopAdmin, some of required attributes are not set " + attributes;
        }
    }
}

