/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsGroupTopInviter;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsGroupTopInviter
implements StatsGroupTopInviter {
    private final int identifier;
    private final long userId;
    private final int invitations;

    private ImmutableStatsGroupTopInviter(long userId, int invitations) {
        this.userId = userId;
        this.invitations = invitations;
        this.identifier = StatsGroupTopInviter.super.identifier();
    }

    private ImmutableStatsGroupTopInviter(Builder builder) {
        this.userId = builder.userId;
        this.invitations = builder.invitations;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsGroupTopInviter.super.identifier();
    }

    private ImmutableStatsGroupTopInviter(int identifier, long userId, int invitations) {
        this.identifier = identifier;
        this.userId = userId;
        this.invitations = invitations;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int invitations() {
        return this.invitations;
    }

    public final ImmutableStatsGroupTopInviter withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsGroupTopInviter(value, this.userId, this.invitations);
    }

    public final ImmutableStatsGroupTopInviter withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableStatsGroupTopInviter(this.identifier, value, this.invitations);
    }

    public final ImmutableStatsGroupTopInviter withInvitations(int value) {
        if (this.invitations == value) {
            return this;
        }
        return new ImmutableStatsGroupTopInviter(this.identifier, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGroupTopInviter && this.equalTo(0, (ImmutableStatsGroupTopInviter)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsGroupTopInviter another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.invitations == another.invitations;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.invitations;
        return h;
    }

    public String toString() {
        return "StatsGroupTopInviter{identifier=" + this.identifier + ", userId=" + this.userId + ", invitations=" + this.invitations + "}";
    }

    public static ImmutableStatsGroupTopInviter of(long userId, int invitations) {
        return new ImmutableStatsGroupTopInviter(userId, invitations);
    }

    public static ImmutableStatsGroupTopInviter copyOf(StatsGroupTopInviter instance) {
        if (instance instanceof ImmutableStatsGroupTopInviter) {
            return (ImmutableStatsGroupTopInviter)instance;
        }
        return ImmutableStatsGroupTopInviter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_INVITATIONS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private int invitations;

        private Builder() {
        }

        public final Builder from(StatsGroupTopInviter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StatsGroupTopInviter instance;
            long bits = 0L;
            if (object instanceof StatsGroupTopInviter) {
                instance = (StatsGroupTopInviter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.invitations(instance.invitations());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder invitations(int invitations) {
            this.invitations = invitations;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStatsGroupTopInviter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGroupTopInviter(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("invitations");
            }
            return "Cannot build StatsGroupTopInviter, some of required attributes are not set " + attributes;
        }
    }
}

