/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsGroupTopPoster;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsGroupTopPoster
implements StatsGroupTopPoster {
    private final int identifier;
    private final long userId;
    private final int messages;
    private final int avgChars;

    private ImmutableStatsGroupTopPoster(long userId, int messages, int avgChars) {
        this.userId = userId;
        this.messages = messages;
        this.avgChars = avgChars;
        this.identifier = StatsGroupTopPoster.super.identifier();
    }

    private ImmutableStatsGroupTopPoster(Builder builder) {
        this.userId = builder.userId;
        this.messages = builder.messages;
        this.avgChars = builder.avgChars;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsGroupTopPoster.super.identifier();
    }

    private ImmutableStatsGroupTopPoster(int identifier, long userId, int messages, int avgChars) {
        this.identifier = identifier;
        this.userId = userId;
        this.messages = messages;
        this.avgChars = avgChars;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int messages() {
        return this.messages;
    }

    @Override
    public int avgChars() {
        return this.avgChars;
    }

    public final ImmutableStatsGroupTopPoster withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsGroupTopPoster(value, this.userId, this.messages, this.avgChars);
    }

    public final ImmutableStatsGroupTopPoster withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableStatsGroupTopPoster(this.identifier, value, this.messages, this.avgChars);
    }

    public final ImmutableStatsGroupTopPoster withMessages(int value) {
        if (this.messages == value) {
            return this;
        }
        return new ImmutableStatsGroupTopPoster(this.identifier, this.userId, value, this.avgChars);
    }

    public final ImmutableStatsGroupTopPoster withAvgChars(int value) {
        if (this.avgChars == value) {
            return this;
        }
        return new ImmutableStatsGroupTopPoster(this.identifier, this.userId, this.messages, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsGroupTopPoster && this.equalTo(0, (ImmutableStatsGroupTopPoster)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsGroupTopPoster another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.messages == another.messages && this.avgChars == another.avgChars;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.messages;
        h += (h << 5) + this.avgChars;
        return h;
    }

    public String toString() {
        return "StatsGroupTopPoster{identifier=" + this.identifier + ", userId=" + this.userId + ", messages=" + this.messages + ", avgChars=" + this.avgChars + "}";
    }

    public static ImmutableStatsGroupTopPoster of(long userId, int messages, int avgChars) {
        return new ImmutableStatsGroupTopPoster(userId, messages, avgChars);
    }

    public static ImmutableStatsGroupTopPoster copyOf(StatsGroupTopPoster instance) {
        if (instance instanceof ImmutableStatsGroupTopPoster) {
            return (ImmutableStatsGroupTopPoster)instance;
        }
        return ImmutableStatsGroupTopPoster.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_MESSAGES = 2L;
        private static final long INIT_BIT_AVG_CHARS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long userId;
        private int messages;
        private int avgChars;

        private Builder() {
        }

        public final Builder from(StatsGroupTopPoster instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StatsGroupTopPoster instance;
            long bits = 0L;
            if (object instanceof StatsGroupTopPoster) {
                instance = (StatsGroupTopPoster)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.messages(instance.messages());
                this.userId(instance.userId());
                this.avgChars(instance.avgChars());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder messages(int messages) {
            this.messages = messages;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder avgChars(int avgChars) {
            this.avgChars = avgChars;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableStatsGroupTopPoster build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsGroupTopPoster(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("messages");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("avgChars");
            }
            return "Cannot build StatsGroupTopPoster, some of required attributes are not set " + attributes;
        }
    }
}

