/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.StatsPercentValue;
import telegram4j.tl.api.TlObject;

public final class ImmutableStatsPercentValue
implements StatsPercentValue {
    private final int identifier;
    private final double part;
    private final double total;

    private ImmutableStatsPercentValue(double part, double total) {
        this.part = part;
        this.total = total;
        this.identifier = StatsPercentValue.super.identifier();
    }

    private ImmutableStatsPercentValue(Builder builder) {
        this.part = builder.part;
        this.total = builder.total;
        this.identifier = builder.identifierIsSet() ? builder.identifier : StatsPercentValue.super.identifier();
    }

    private ImmutableStatsPercentValue(int identifier, double part, double total) {
        this.identifier = identifier;
        this.part = part;
        this.total = total;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public double part() {
        return this.part;
    }

    @Override
    public double total() {
        return this.total;
    }

    public final ImmutableStatsPercentValue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStatsPercentValue(value, this.part, this.total);
    }

    public final ImmutableStatsPercentValue withPart(double value) {
        if (Double.doubleToLongBits(this.part) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStatsPercentValue(this.identifier, value, this.total);
    }

    public final ImmutableStatsPercentValue withTotal(double value) {
        if (Double.doubleToLongBits(this.total) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStatsPercentValue(this.identifier, this.part, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsPercentValue && this.equalTo(0, (ImmutableStatsPercentValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsPercentValue another) {
        return this.identifier == another.identifier && Double.doubleToLongBits(this.part) == Double.doubleToLongBits(another.part) && Double.doubleToLongBits(this.total) == Double.doubleToLongBits(another.total);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Double.hashCode(this.part);
        h += (h << 5) + Double.hashCode(this.total);
        return h;
    }

    public String toString() {
        return "StatsPercentValue{identifier=" + this.identifier + ", part=" + this.part + ", total=" + this.total + "}";
    }

    public static ImmutableStatsPercentValue of(double part, double total) {
        return new ImmutableStatsPercentValue(part, total);
    }

    public static ImmutableStatsPercentValue copyOf(StatsPercentValue instance) {
        if (instance instanceof ImmutableStatsPercentValue) {
            return (ImmutableStatsPercentValue)instance;
        }
        return ImmutableStatsPercentValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PART = 1L;
        private static final long INIT_BIT_TOTAL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private double part;
        private double total;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StatsPercentValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StatsPercentValue) {
                instance = (StatsPercentValue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.total(instance.total());
                this.part(instance.part());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder part(double part) {
            this.part = part;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder total(double total) {
            this.total = total;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStatsPercentValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsPercentValue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("part");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("total");
            }
            return "Cannot build StatsPercentValue, some of required attributes are not set " + attributes;
        }
    }
}

