/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StickerPack;
import telegram4j.tl.api.TlObject;

public final class ImmutableStickerPack
implements StickerPack {
    private final int identifier;
    private final String emoticon;
    private final List<Long> documents;

    private ImmutableStickerPack(String emoticon) {
        this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
        this.documents = Collections.emptyList();
        this.identifier = StickerPack.super.identifier();
    }

    private ImmutableStickerPack(Builder builder) {
        this.emoticon = builder.emoticon;
        this.documents = ImmutableStickerPack.createUnmodifiableList(true, builder.documents);
        this.identifier = builder.identifierIsSet() ? builder.identifier : StickerPack.super.identifier();
    }

    private ImmutableStickerPack(int identifier, String emoticon, List<Long> documents) {
        this.identifier = identifier;
        this.emoticon = emoticon;
        this.documents = documents;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String emoticon() {
        return this.emoticon;
    }

    @Override
    public List<Long> documents() {
        return this.documents;
    }

    public final ImmutableStickerPack withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStickerPack(value, this.emoticon, this.documents);
    }

    public final ImmutableStickerPack withEmoticon(String value) {
        String newValue = Objects.requireNonNull(value, "emoticon");
        if (this.emoticon.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerPack(this.identifier, newValue, this.documents);
    }

    public final ImmutableStickerPack withDocuments(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableStickerPack.createUnmodifiableList(false, wrappedList);
        return new ImmutableStickerPack(this.identifier, this.emoticon, newValue);
    }

    public final ImmutableStickerPack withDocuments(Iterable<Long> elements) {
        if (this.documents == elements) {
            return this;
        }
        List<Long> newValue = ImmutableStickerPack.createUnmodifiableList(false, ImmutableStickerPack.createSafeList(elements, true, false));
        return new ImmutableStickerPack(this.identifier, this.emoticon, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerPack && this.equalTo(0, (ImmutableStickerPack)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerPack another) {
        return this.identifier == another.identifier && this.emoticon.equals(another.emoticon) && this.documents.equals(another.documents);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.emoticon.hashCode();
        h += (h << 5) + this.documents.hashCode();
        return h;
    }

    public String toString() {
        return "StickerPack{identifier=" + this.identifier + ", emoticon=" + this.emoticon + ", documents=" + this.documents + "}";
    }

    public static ImmutableStickerPack of(String emoticon) {
        return new ImmutableStickerPack(emoticon);
    }

    public static ImmutableStickerPack copyOf(StickerPack instance) {
        if (instance instanceof ImmutableStickerPack) {
            return (ImmutableStickerPack)instance;
        }
        return ImmutableStickerPack.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOTICON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String emoticon;
        private List<Long> documents = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(StickerPack instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StickerPack instance;
            long bits = 0L;
            if (object instanceof StickerPack) {
                instance = (StickerPack)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllDocuments(instance.documents());
                this.emoticon(instance.emoticon());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder emoticon(String emoticon) {
            this.emoticon = Objects.requireNonNull(emoticon, "emoticon");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addDocument(long element) {
            this.documents.add(element);
            return this;
        }

        public final Builder addDocuments(long ... elements) {
            for (long element : elements) {
                this.documents.add(element);
            }
            return this;
        }

        public final Builder documents(Iterable<Long> elements) {
            this.documents.clear();
            return this.addAllDocuments(elements);
        }

        public final Builder addAllDocuments(Iterable<Long> elements) {
            for (Long element : elements) {
                this.documents.add(Objects.requireNonNull(element, "documents element"));
            }
            return this;
        }

        public ImmutableStickerPack build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerPack(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoticon");
            }
            return "Cannot build StickerPack, some of required attributes are not set " + attributes;
        }
    }
}

