/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.StickerSet;
import telegram4j.tl.api.TlObject;

public final class ImmutableStickerSet
implements StickerSet {
    private final int identifier;
    private final int flags;
    private final boolean archived;
    private final boolean official;
    private final boolean masks;
    private final boolean animated;
    private final boolean videos;
    private final boolean emojis;
    @Nullable
    private final Integer installedDate;
    private final long id;
    private final long accessHash;
    private final String title;
    private final String shortName;
    @Nullable
    private final List<PhotoSize> thumbs;
    @Nullable
    private final Integer thumbDcId;
    @Nullable
    private final Integer thumbVersion;
    @Nullable
    private final Long thumbDocumentId;
    private final int count;
    private final int hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStickerSet(long id, long accessHash, String title, String shortName, int count, int hash) {
        this.id = id;
        this.accessHash = accessHash;
        this.title = Objects.requireNonNull(title, "title");
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.count = count;
        this.hash = hash;
        this.installedDate = null;
        this.thumbs = null;
        this.thumbDcId = null;
        this.thumbVersion = null;
        this.thumbDocumentId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.archived = this.initShim.archived();
        this.official = this.initShim.official();
        this.masks = this.initShim.masks();
        this.animated = this.initShim.animated();
        this.videos = this.initShim.videos();
        this.emojis = this.initShim.emojis();
        this.initShim = null;
    }

    private ImmutableStickerSet(Builder builder) {
        this.installedDate = builder.installedDate;
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.title = builder.title;
        this.shortName = builder.shortName;
        this.thumbs = builder.thumbs == null ? null : ImmutableStickerSet.createUnmodifiableList(true, builder.thumbs);
        this.thumbDcId = builder.thumbDcId;
        this.thumbVersion = builder.thumbVersion;
        this.thumbDocumentId = builder.thumbDocumentId;
        this.count = builder.count;
        this.hash = builder.hash;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.archivedIsSet()) {
            this.initShim.archived(builder.archived);
        }
        if (builder.officialIsSet()) {
            this.initShim.official(builder.official);
        }
        if (builder.masksIsSet()) {
            this.initShim.masks(builder.masks);
        }
        if (builder.animatedIsSet()) {
            this.initShim.animated(builder.animated);
        }
        if (builder.videosIsSet()) {
            this.initShim.videos(builder.videos);
        }
        if (builder.emojisIsSet()) {
            this.initShim.emojis(builder.emojis);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.archived = this.initShim.archived();
        this.official = this.initShim.official();
        this.masks = this.initShim.masks();
        this.animated = this.initShim.animated();
        this.videos = this.initShim.videos();
        this.emojis = this.initShim.emojis();
        this.initShim = null;
    }

    private ImmutableStickerSet(int identifier, int flags, boolean archived, boolean official, boolean masks, boolean animated, boolean videos, boolean emojis, @Nullable Integer installedDate, long id, long accessHash, String title, String shortName, @Nullable List<PhotoSize> thumbs, @Nullable Integer thumbDcId, @Nullable Integer thumbVersion, @Nullable Long thumbDocumentId, int count, int hash) {
        this.identifier = identifier;
        this.flags = flags;
        this.archived = archived;
        this.official = official;
        this.masks = masks;
        this.animated = animated;
        this.videos = videos;
        this.emojis = emojis;
        this.installedDate = installedDate;
        this.id = id;
        this.accessHash = accessHash;
        this.title = title;
        this.shortName = shortName;
        this.thumbs = thumbs;
        this.thumbDcId = thumbDcId;
        this.thumbVersion = thumbVersion;
        this.thumbDocumentId = thumbDocumentId;
        this.count = count;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return StickerSet.super.identifier();
    }

    private int flagsInitialize() {
        return StickerSet.super.flags();
    }

    private boolean archivedInitialize() {
        return StickerSet.super.archived();
    }

    private boolean officialInitialize() {
        return StickerSet.super.official();
    }

    private boolean masksInitialize() {
        return StickerSet.super.masks();
    }

    private boolean animatedInitialize() {
        return StickerSet.super.animated();
    }

    private boolean videosInitialize() {
        return StickerSet.super.videos();
    }

    private boolean emojisInitialize() {
        return StickerSet.super.emojis();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean archived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.archived() : this.archived;
    }

    @Override
    public boolean official() {
        InitShim shim = this.initShim;
        return shim != null ? shim.official() : this.official;
    }

    @Override
    public boolean masks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.masks() : this.masks;
    }

    @Override
    public boolean animated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.animated() : this.animated;
    }

    @Override
    public boolean videos() {
        InitShim shim = this.initShim;
        return shim != null ? shim.videos() : this.videos;
    }

    @Override
    public boolean emojis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.emojis() : this.emojis;
    }

    @Override
    @Nullable
    public Integer installedDate() {
        return this.installedDate;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    @Nullable
    public List<PhotoSize> thumbs() {
        return this.thumbs;
    }

    @Override
    @Nullable
    public Integer thumbDcId() {
        return this.thumbDcId;
    }

    @Override
    @Nullable
    public Integer thumbVersion() {
        return this.thumbVersion;
    }

    @Override
    @Nullable
    public Long thumbDocumentId() {
        return this.thumbDocumentId;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    public final ImmutableStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStickerSet(value, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, value, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withArchived(boolean value) {
        if (this.archived == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, value, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withOfficial(boolean value) {
        if (this.official == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, value, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withMasks(boolean value) {
        if (this.masks == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, value, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withAnimated(boolean value) {
        if (this.animated == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, value, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withVideos(boolean value) {
        if (this.videos == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, value, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withEmojis(boolean value) {
        if (this.emojis == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, value, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withInstalledDate(@Nullable Integer value) {
        if (Objects.equals(this.installedDate, value)) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, value, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, value, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, value, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, newValue, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, newValue, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withThumbs(PhotoSize ... elements) {
        if (elements == null) {
            return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, null, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
        }
        List<PhotoSize> newValue = Arrays.asList(elements) == null ? null : ImmutableStickerSet.createUnmodifiableList(false, ImmutableStickerSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, newValue, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withThumbs(@Nullable Iterable<? extends PhotoSize> elements) {
        if (this.thumbs == elements) {
            return this;
        }
        List<PhotoSize> newValue = elements == null ? null : ImmutableStickerSet.createUnmodifiableList(false, ImmutableStickerSet.createSafeList(elements, true, false));
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, newValue, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withThumbDcId(@Nullable Integer value) {
        if (Objects.equals(this.thumbDcId, value)) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, value, this.thumbVersion, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withThumbVersion(@Nullable Integer value) {
        if (Objects.equals(this.thumbVersion, value)) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, value, this.thumbDocumentId, this.count, this.hash);
    }

    public final ImmutableStickerSet withThumbDocumentId(@Nullable Long value) {
        if (Objects.equals(this.thumbDocumentId, value)) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, value, this.count, this.hash);
    }

    public final ImmutableStickerSet withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, value, this.hash);
    }

    public final ImmutableStickerSet withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableStickerSet(this.identifier, this.flags, this.archived, this.official, this.masks, this.animated, this.videos, this.emojis, this.installedDate, this.id, this.accessHash, this.title, this.shortName, this.thumbs, this.thumbDcId, this.thumbVersion, this.thumbDocumentId, this.count, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerSet && this.equalTo(0, (ImmutableStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerSet another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.archived == another.archived && this.official == another.official && this.masks == another.masks && this.animated == another.animated && this.videos == another.videos && this.emojis == another.emojis && Objects.equals(this.installedDate, another.installedDate) && this.id == another.id && this.accessHash == another.accessHash && this.title.equals(another.title) && this.shortName.equals(another.shortName) && Objects.equals(this.thumbs, another.thumbs) && Objects.equals(this.thumbDcId, another.thumbDcId) && Objects.equals(this.thumbVersion, another.thumbVersion) && Objects.equals(this.thumbDocumentId, another.thumbDocumentId) && this.count == another.count && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.archived);
        h += (h << 5) + Boolean.hashCode(this.official);
        h += (h << 5) + Boolean.hashCode(this.masks);
        h += (h << 5) + Boolean.hashCode(this.animated);
        h += (h << 5) + Boolean.hashCode(this.videos);
        h += (h << 5) + Boolean.hashCode(this.emojis);
        h += (h << 5) + Objects.hashCode(this.installedDate);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.shortName.hashCode();
        h += (h << 5) + Objects.hashCode(this.thumbs);
        h += (h << 5) + Objects.hashCode(this.thumbDcId);
        h += (h << 5) + Objects.hashCode(this.thumbVersion);
        h += (h << 5) + Objects.hashCode(this.thumbDocumentId);
        h += (h << 5) + this.count;
        h += (h << 5) + this.hash;
        return h;
    }

    public String toString() {
        return "StickerSet{identifier=" + this.identifier + ", flags=" + this.flags + ", archived=" + this.archived + ", official=" + this.official + ", masks=" + this.masks + ", animated=" + this.animated + ", videos=" + this.videos + ", emojis=" + this.emojis + ", installedDate=" + this.installedDate + ", id=" + this.id + ", accessHash=" + this.accessHash + ", title=" + this.title + ", shortName=" + this.shortName + ", thumbs=" + this.thumbs + ", thumbDcId=" + this.thumbDcId + ", thumbVersion=" + this.thumbVersion + ", thumbDocumentId=" + this.thumbDocumentId + ", count=" + this.count + ", hash=" + this.hash + "}";
    }

    public static ImmutableStickerSet of(long id, long accessHash, String title, String shortName, int count, int hash) {
        return new ImmutableStickerSet(id, accessHash, title, shortName, count, hash);
    }

    public static ImmutableStickerSet copyOf(StickerSet instance) {
        if (instance instanceof ImmutableStickerSet) {
            return (ImmutableStickerSet)instance;
        }
        return ImmutableStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_TITLE = 4L;
        private static final long INIT_BIT_SHORT_NAME = 8L;
        private static final long INIT_BIT_COUNT = 16L;
        private static final long INIT_BIT_HASH = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ARCHIVED = 4L;
        private static final long OPT_BIT_OFFICIAL = 8L;
        private static final long OPT_BIT_MASKS = 16L;
        private static final long OPT_BIT_ANIMATED = 32L;
        private static final long OPT_BIT_VIDEOS = 64L;
        private static final long OPT_BIT_EMOJIS = 128L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean archived;
        private boolean official;
        private boolean masks;
        private boolean animated;
        private boolean videos;
        private boolean emojis;
        private Integer installedDate;
        private long id;
        private long accessHash;
        private String title;
        private String shortName;
        private List<PhotoSize> thumbs = null;
        private Integer thumbDcId;
        private Integer thumbVersion;
        private Long thumbDocumentId;
        private int count;
        private int hash;

        private Builder() {
        }

        public final Builder from(StickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StickerSet instance;
            long bits = 0L;
            if (object instanceof StickerSet) {
                instance = (StickerSet)object;
                this.emojis(instance.emojis());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.count(instance.count());
                this.official(instance.official());
                this.masks(instance.masks());
                this.videos(instance.videos());
                Integer thumbDcIdValue = instance.thumbDcId();
                if (thumbDcIdValue != null) {
                    this.thumbDcId(thumbDcIdValue);
                }
                this.title(instance.title());
                this.archived(instance.archived());
                Integer installedDateValue = instance.installedDate();
                if (installedDateValue != null) {
                    this.installedDate(installedDateValue);
                }
                this.animated(instance.animated());
                this.accessHash(instance.accessHash());
                Long thumbDocumentIdValue = instance.thumbDocumentId();
                if (thumbDocumentIdValue != null) {
                    this.thumbDocumentId(thumbDocumentIdValue);
                }
                this.id(instance.id());
                this.shortName(instance.shortName());
                Integer thumbVersionValue = instance.thumbVersion();
                if (thumbVersionValue != null) {
                    this.thumbVersion(thumbVersionValue);
                }
                this.hash(instance.hash());
                List<PhotoSize> thumbsValue = instance.thumbs();
                if (thumbsValue != null) {
                    this.addAllThumbs(thumbsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder archived(boolean archived) {
            this.archived = archived;
            this.optBits |= 4L;
            return this;
        }

        public final Builder official(boolean official) {
            this.official = official;
            this.optBits |= 8L;
            return this;
        }

        public final Builder masks(boolean masks) {
            this.masks = masks;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder animated(boolean animated) {
            this.animated = animated;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder videos(boolean videos) {
            this.videos = videos;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder emojis(boolean emojis) {
            this.emojis = emojis;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder installedDate(@Nullable Integer installedDate) {
            this.installedDate = installedDate;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addThumb(PhotoSize element) {
            if (this.thumbs == null) {
                this.thumbs = new ArrayList<PhotoSize>();
            }
            this.thumbs.add(Objects.requireNonNull(element, "thumbs element"));
            return this;
        }

        public final Builder addThumbs(PhotoSize ... elements) {
            if (this.thumbs == null) {
                this.thumbs = new ArrayList<PhotoSize>();
            }
            for (PhotoSize element : elements) {
                this.thumbs.add(Objects.requireNonNull(element, "thumbs element"));
            }
            return this;
        }

        public final Builder thumbs(@Nullable Iterable<? extends PhotoSize> elements) {
            if (elements == null) {
                this.thumbs = null;
                return this;
            }
            this.thumbs = new ArrayList<PhotoSize>();
            return this.addAllThumbs(elements);
        }

        public final Builder addAllThumbs(Iterable<? extends PhotoSize> elements) {
            Objects.requireNonNull(elements, "thumbs element");
            if (this.thumbs == null) {
                this.thumbs = new ArrayList<PhotoSize>();
            }
            for (PhotoSize photoSize : elements) {
                this.thumbs.add(Objects.requireNonNull(photoSize, "thumbs element"));
            }
            return this;
        }

        public final Builder thumbDcId(@Nullable Integer thumbDcId) {
            this.thumbDcId = thumbDcId;
            return this;
        }

        public final Builder thumbVersion(@Nullable Integer thumbVersion) {
            this.thumbVersion = thumbVersion;
            return this;
        }

        public final Builder thumbDocumentId(@Nullable Long thumbDocumentId) {
            this.thumbDocumentId = thumbDocumentId;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean archivedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean officialIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean masksIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean animatedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean videosIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean emojisIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("shortName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build StickerSet, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte archivedBuildStage = 0;
        private boolean archived;
        private byte officialBuildStage = 0;
        private boolean official;
        private byte masksBuildStage = 0;
        private boolean masks;
        private byte animatedBuildStage = 0;
        private boolean animated;
        private byte videosBuildStage = 0;
        private boolean videos;
        private byte emojisBuildStage = 0;
        private boolean emojis;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableStickerSet.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableStickerSet.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean archived() {
            if (this.archivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.archivedBuildStage == 0) {
                this.archivedBuildStage = (byte)-1;
                this.archived = ImmutableStickerSet.this.archivedInitialize();
                this.archivedBuildStage = 1;
            }
            return this.archived;
        }

        void archived(boolean archived) {
            this.archived = archived;
            this.archivedBuildStage = 1;
        }

        boolean official() {
            if (this.officialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.officialBuildStage == 0) {
                this.officialBuildStage = (byte)-1;
                this.official = ImmutableStickerSet.this.officialInitialize();
                this.officialBuildStage = 1;
            }
            return this.official;
        }

        void official(boolean official) {
            this.official = official;
            this.officialBuildStage = 1;
        }

        boolean masks() {
            if (this.masksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.masksBuildStage == 0) {
                this.masksBuildStage = (byte)-1;
                this.masks = ImmutableStickerSet.this.masksInitialize();
                this.masksBuildStage = 1;
            }
            return this.masks;
        }

        void masks(boolean masks) {
            this.masks = masks;
            this.masksBuildStage = 1;
        }

        boolean animated() {
            if (this.animatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.animatedBuildStage == 0) {
                this.animatedBuildStage = (byte)-1;
                this.animated = ImmutableStickerSet.this.animatedInitialize();
                this.animatedBuildStage = 1;
            }
            return this.animated;
        }

        void animated(boolean animated) {
            this.animated = animated;
            this.animatedBuildStage = 1;
        }

        boolean videos() {
            if (this.videosBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videosBuildStage == 0) {
                this.videosBuildStage = (byte)-1;
                this.videos = ImmutableStickerSet.this.videosInitialize();
                this.videosBuildStage = 1;
            }
            return this.videos;
        }

        void videos(boolean videos) {
            this.videos = videos;
            this.videosBuildStage = 1;
        }

        boolean emojis() {
            if (this.emojisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emojisBuildStage == 0) {
                this.emojisBuildStage = (byte)-1;
                this.emojis = ImmutableStickerSet.this.emojisInitialize();
                this.emojisBuildStage = 1;
            }
            return this.emojis;
        }

        void emojis(boolean emojis) {
            this.emojis = emojis;
            this.emojisBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.archivedBuildStage == -1) {
                attributes.add("archived");
            }
            if (this.officialBuildStage == -1) {
                attributes.add("official");
            }
            if (this.masksBuildStage == -1) {
                attributes.add("masks");
            }
            if (this.animatedBuildStage == -1) {
                attributes.add("animated");
            }
            if (this.videosBuildStage == -1) {
                attributes.add("videos");
            }
            if (this.emojisBuildStage == -1) {
                attributes.add("emojis");
            }
            return "Cannot build StickerSet, attribute initializers form cycle " + attributes;
        }
    }
}

