/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.StickerPack;
import telegram4j.tl.StickerSet;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.StickerSetFullCovered;
import telegram4j.tl.api.TlObject;

public final class ImmutableStickerSetFullCovered
implements StickerSetFullCovered {
    private final int identifier;
    private final StickerSet set;
    private final List<StickerPack> packs;
    private final List<Document> documents;

    private ImmutableStickerSetFullCovered(StickerSet set) {
        this.set = Objects.requireNonNull(set, "set");
        this.packs = Collections.emptyList();
        this.documents = Collections.emptyList();
        this.identifier = StickerSetFullCovered.super.identifier();
    }

    private ImmutableStickerSetFullCovered(Builder builder) {
        this.set = builder.set;
        this.packs = ImmutableStickerSetFullCovered.createUnmodifiableList(true, builder.packs);
        this.documents = ImmutableStickerSetFullCovered.createUnmodifiableList(true, builder.documents);
        this.identifier = builder.identifierIsSet() ? builder.identifier : StickerSetFullCovered.super.identifier();
    }

    private ImmutableStickerSetFullCovered(int identifier, StickerSet set, List<StickerPack> packs, List<Document> documents) {
        this.identifier = identifier;
        this.set = set;
        this.packs = packs;
        this.documents = documents;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StickerSet set() {
        return this.set;
    }

    @Override
    public List<StickerPack> packs() {
        return this.packs;
    }

    @Override
    public List<Document> documents() {
        return this.documents;
    }

    public final ImmutableStickerSetFullCovered withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStickerSetFullCovered(value, this.set, this.packs, this.documents);
    }

    public final ImmutableStickerSetFullCovered withSet(StickerSet value) {
        if (this.set == value) {
            return this;
        }
        StickerSet newValue = Objects.requireNonNull(value, "set");
        return new ImmutableStickerSetFullCovered(this.identifier, newValue, this.packs, this.documents);
    }

    public final ImmutableStickerSetFullCovered withPacks(StickerPack ... elements) {
        List<StickerPack> newValue = ImmutableStickerSetFullCovered.createUnmodifiableList(false, ImmutableStickerSetFullCovered.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSetFullCovered(this.identifier, this.set, newValue, this.documents);
    }

    public final ImmutableStickerSetFullCovered withPacks(Iterable<? extends StickerPack> elements) {
        if (this.packs == elements) {
            return this;
        }
        List<StickerPack> newValue = ImmutableStickerSetFullCovered.createUnmodifiableList(false, ImmutableStickerSetFullCovered.createSafeList(elements, true, false));
        return new ImmutableStickerSetFullCovered(this.identifier, this.set, newValue, this.documents);
    }

    public final ImmutableStickerSetFullCovered withDocuments(Document ... elements) {
        List<Document> newValue = ImmutableStickerSetFullCovered.createUnmodifiableList(false, ImmutableStickerSetFullCovered.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSetFullCovered(this.identifier, this.set, this.packs, newValue);
    }

    public final ImmutableStickerSetFullCovered withDocuments(Iterable<? extends Document> elements) {
        if (this.documents == elements) {
            return this;
        }
        List<Document> newValue = ImmutableStickerSetFullCovered.createUnmodifiableList(false, ImmutableStickerSetFullCovered.createSafeList(elements, true, false));
        return new ImmutableStickerSetFullCovered(this.identifier, this.set, this.packs, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerSetFullCovered && this.equalTo(0, (ImmutableStickerSetFullCovered)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerSetFullCovered another) {
        return this.identifier == another.identifier && this.set.equals(another.set) && this.packs.equals(another.packs) && this.documents.equals(another.documents);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.packs.hashCode();
        h += (h << 5) + this.documents.hashCode();
        return h;
    }

    public String toString() {
        return "StickerSetFullCovered{identifier=" + this.identifier + ", set=" + this.set + ", packs=" + this.packs + ", documents=" + this.documents + "}";
    }

    public static ImmutableStickerSetFullCovered of(StickerSet set) {
        return new ImmutableStickerSetFullCovered(set);
    }

    public static ImmutableStickerSetFullCovered copyOf(StickerSetFullCovered instance) {
        if (instance instanceof ImmutableStickerSetFullCovered) {
            return (ImmutableStickerSetFullCovered)instance;
        }
        return ImmutableStickerSetFullCovered.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private StickerSet set;
        private List<StickerPack> packs = new ArrayList<StickerPack>();
        private List<Document> documents = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(StickerSetCovered instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StickerSetFullCovered instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StickerSetCovered instance;
            long bits = 0L;
            if (object instanceof StickerSetCovered) {
                instance = (StickerSetCovered)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.set(instance.set());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StickerSetFullCovered) {
                instance = (StickerSetFullCovered)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.set(instance.set());
                    bits |= 2L;
                }
                this.addAllDocuments(instance.documents());
                this.addAllPacks(instance.packs());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder set(StickerSet set) {
            this.set = Objects.requireNonNull(set, "set");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPack(StickerPack element) {
            this.packs.add(Objects.requireNonNull(element, "packs element"));
            return this;
        }

        public final Builder addPacks(StickerPack ... elements) {
            for (StickerPack element : elements) {
                this.packs.add(Objects.requireNonNull(element, "packs element"));
            }
            return this;
        }

        public final Builder packs(Iterable<? extends StickerPack> elements) {
            this.packs.clear();
            return this.addAllPacks(elements);
        }

        public final Builder addAllPacks(Iterable<? extends StickerPack> elements) {
            for (StickerPack stickerPack : elements) {
                this.packs.add(Objects.requireNonNull(stickerPack, "packs element"));
            }
            return this;
        }

        public final Builder addDocument(Document element) {
            this.documents.add(Objects.requireNonNull(element, "documents element"));
            return this;
        }

        public final Builder addDocuments(Document ... elements) {
            for (Document element : elements) {
                this.documents.add(Objects.requireNonNull(element, "documents element"));
            }
            return this;
        }

        public final Builder documents(Iterable<? extends Document> elements) {
            this.documents.clear();
            return this.addAllDocuments(elements);
        }

        public final Builder addAllDocuments(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.documents.add(Objects.requireNonNull(document, "documents element"));
            }
            return this;
        }

        public ImmutableStickerSetFullCovered build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerSetFullCovered(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("set");
            }
            return "Cannot build StickerSetFullCovered, some of required attributes are not set " + attributes;
        }
    }
}

