/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.StickerSet;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.StickerSetMultiCovered;
import telegram4j.tl.api.TlObject;

public final class ImmutableStickerSetMultiCovered
implements StickerSetMultiCovered {
    private final int identifier;
    private final StickerSet set;
    private final List<Document> covers;

    private ImmutableStickerSetMultiCovered(StickerSet set) {
        this.set = Objects.requireNonNull(set, "set");
        this.covers = Collections.emptyList();
        this.identifier = StickerSetMultiCovered.super.identifier();
    }

    private ImmutableStickerSetMultiCovered(Builder builder) {
        this.set = builder.set;
        this.covers = ImmutableStickerSetMultiCovered.createUnmodifiableList(true, builder.covers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : StickerSetMultiCovered.super.identifier();
    }

    private ImmutableStickerSetMultiCovered(int identifier, StickerSet set, List<Document> covers) {
        this.identifier = identifier;
        this.set = set;
        this.covers = covers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StickerSet set() {
        return this.set;
    }

    @Override
    public List<Document> covers() {
        return this.covers;
    }

    public final ImmutableStickerSetMultiCovered withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStickerSetMultiCovered(value, this.set, this.covers);
    }

    public final ImmutableStickerSetMultiCovered withSet(StickerSet value) {
        if (this.set == value) {
            return this;
        }
        StickerSet newValue = Objects.requireNonNull(value, "set");
        return new ImmutableStickerSetMultiCovered(this.identifier, newValue, this.covers);
    }

    public final ImmutableStickerSetMultiCovered withCovers(Document ... elements) {
        List<Document> newValue = ImmutableStickerSetMultiCovered.createUnmodifiableList(false, ImmutableStickerSetMultiCovered.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSetMultiCovered(this.identifier, this.set, newValue);
    }

    public final ImmutableStickerSetMultiCovered withCovers(Iterable<? extends Document> elements) {
        if (this.covers == elements) {
            return this;
        }
        List<Document> newValue = ImmutableStickerSetMultiCovered.createUnmodifiableList(false, ImmutableStickerSetMultiCovered.createSafeList(elements, true, false));
        return new ImmutableStickerSetMultiCovered(this.identifier, this.set, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerSetMultiCovered && this.equalTo(0, (ImmutableStickerSetMultiCovered)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerSetMultiCovered another) {
        return this.identifier == another.identifier && this.set.equals(another.set) && this.covers.equals(another.covers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.covers.hashCode();
        return h;
    }

    public String toString() {
        return "StickerSetMultiCovered{identifier=" + this.identifier + ", set=" + this.set + ", covers=" + this.covers + "}";
    }

    public static ImmutableStickerSetMultiCovered of(StickerSet set) {
        return new ImmutableStickerSetMultiCovered(set);
    }

    public static ImmutableStickerSetMultiCovered copyOf(StickerSetMultiCovered instance) {
        if (instance instanceof ImmutableStickerSetMultiCovered) {
            return (ImmutableStickerSetMultiCovered)instance;
        }
        return ImmutableStickerSetMultiCovered.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private StickerSet set;
        private List<Document> covers = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(StickerSetCovered instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StickerSetMultiCovered instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StickerSetCovered instance;
            long bits = 0L;
            if (object instanceof StickerSetCovered) {
                instance = (StickerSetCovered)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.set(instance.set());
                    bits |= 2L;
                }
            }
            if (object instanceof StickerSetMultiCovered) {
                instance = (StickerSetMultiCovered)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.set(instance.set());
                    bits |= 2L;
                }
                this.addAllCovers(instance.covers());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder set(StickerSet set) {
            this.set = Objects.requireNonNull(set, "set");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addCover(Document element) {
            this.covers.add(Objects.requireNonNull(element, "covers element"));
            return this;
        }

        public final Builder addCovers(Document ... elements) {
            for (Document element : elements) {
                this.covers.add(Objects.requireNonNull(element, "covers element"));
            }
            return this;
        }

        public final Builder covers(Iterable<? extends Document> elements) {
            this.covers.clear();
            return this.addAllCovers(elements);
        }

        public final Builder addAllCovers(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.covers.add(Objects.requireNonNull(document, "covers element"));
            }
            return this;
        }

        public ImmutableStickerSetMultiCovered build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerSetMultiCovered(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("set");
            }
            return "Cannot build StickerSetMultiCovered, some of required attributes are not set " + attributes;
        }
    }
}

