/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextAnchor;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextAnchor
implements TextAnchor {
    private final int identifier;
    private final RichText text;
    private final String name;

    private ImmutableTextAnchor(RichText text, String name) {
        this.text = Objects.requireNonNull(text, "text");
        this.name = Objects.requireNonNull(name, "name");
        this.identifier = TextAnchor.super.identifier();
    }

    private ImmutableTextAnchor(Builder builder) {
        this.text = builder.text;
        this.name = builder.name;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextAnchor.super.identifier();
    }

    private ImmutableTextAnchor(int identifier, RichText text, String name) {
        this.identifier = identifier;
        this.text = text;
        this.name = name;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutableTextAnchor withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextAnchor(value, this.text, this.name);
    }

    public final ImmutableTextAnchor withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutableTextAnchor(this.identifier, newValue, this.name);
    }

    public final ImmutableTextAnchor withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTextAnchor(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextAnchor && this.equalTo(0, (ImmutableTextAnchor)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextAnchor another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "TextAnchor{identifier=" + this.identifier + ", text=" + this.text + ", name=" + this.name + "}";
    }

    public static ImmutableTextAnchor of(RichText text, String name) {
        return new ImmutableTextAnchor(text, name);
    }

    public static ImmutableTextAnchor copyOf(TextAnchor instance) {
        if (instance instanceof ImmutableTextAnchor) {
            return (ImmutableTextAnchor)instance;
        }
        return ImmutableTextAnchor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText text;
        private String name;

        private Builder() {
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TextAnchor instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TextAnchor) {
                instance = (TextAnchor)object;
                this.name(instance.name());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTextAnchor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextAnchor(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TextAnchor, some of required attributes are not set " + attributes;
        }
    }
}

