/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextConcat;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextConcat
implements TextConcat {
    private final int identifier;
    private final List<RichText> texts;

    private ImmutableTextConcat(Builder builder) {
        this.texts = ImmutableTextConcat.createUnmodifiableList(true, builder.texts);
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextConcat.super.identifier();
    }

    private ImmutableTextConcat(int identifier, List<RichText> texts) {
        this.identifier = identifier;
        this.texts = texts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<RichText> texts() {
        return this.texts;
    }

    public final ImmutableTextConcat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextConcat(value, this.texts);
    }

    public final ImmutableTextConcat withTexts(RichText ... elements) {
        List<RichText> newValue = ImmutableTextConcat.createUnmodifiableList(false, ImmutableTextConcat.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTextConcat(this.identifier, newValue);
    }

    public final ImmutableTextConcat withTexts(Iterable<? extends RichText> elements) {
        if (this.texts == elements) {
            return this;
        }
        List<RichText> newValue = ImmutableTextConcat.createUnmodifiableList(false, ImmutableTextConcat.createSafeList(elements, true, false));
        return new ImmutableTextConcat(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextConcat && this.equalTo(0, (ImmutableTextConcat)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextConcat another) {
        return this.identifier == another.identifier && this.texts.equals(another.texts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.texts.hashCode();
        return h;
    }

    public String toString() {
        return "TextConcat{identifier=" + this.identifier + ", texts=" + this.texts + "}";
    }

    public static ImmutableTextConcat copyOf(TextConcat instance) {
        if (instance instanceof ImmutableTextConcat) {
            return (ImmutableTextConcat)instance;
        }
        return ImmutableTextConcat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<RichText> texts = new ArrayList<RichText>();

        private Builder() {
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TextConcat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TextConcat) {
                instance = (TextConcat)object;
                this.addAllTexts(instance.texts());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addText(RichText element) {
            this.texts.add(Objects.requireNonNull(element, "texts element"));
            return this;
        }

        public final Builder addTexts(RichText ... elements) {
            for (RichText element : elements) {
                this.texts.add(Objects.requireNonNull(element, "texts element"));
            }
            return this;
        }

        public final Builder texts(Iterable<? extends RichText> elements) {
            this.texts.clear();
            return this.addAllTexts(elements);
        }

        public final Builder addAllTexts(Iterable<? extends RichText> elements) {
            for (RichText richText : elements) {
                this.texts.add(Objects.requireNonNull(richText, "texts element"));
            }
            return this;
        }

        public ImmutableTextConcat build() {
            return new ImmutableTextConcat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

