/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextEmail;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextEmail
implements TextEmail {
    private final int identifier;
    private final RichText text;
    private final String email;

    private ImmutableTextEmail(RichText text, String email) {
        this.text = Objects.requireNonNull(text, "text");
        this.email = Objects.requireNonNull(email, "email");
        this.identifier = TextEmail.super.identifier();
    }

    private ImmutableTextEmail(Builder builder) {
        this.text = builder.text;
        this.email = builder.email;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextEmail.super.identifier();
    }

    private ImmutableTextEmail(int identifier, RichText text, String email) {
        this.identifier = identifier;
        this.text = text;
        this.email = email;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public String email() {
        return this.email;
    }

    public final ImmutableTextEmail withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextEmail(value, this.text, this.email);
    }

    public final ImmutableTextEmail withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutableTextEmail(this.identifier, newValue, this.email);
    }

    public final ImmutableTextEmail withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (this.email.equals(newValue)) {
            return this;
        }
        return new ImmutableTextEmail(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextEmail && this.equalTo(0, (ImmutableTextEmail)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextEmail another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return "TextEmail{identifier=" + this.identifier + ", text=" + this.text + ", email=" + this.email + "}";
    }

    public static ImmutableTextEmail of(RichText text, String email) {
        return new ImmutableTextEmail(text, email);
    }

    public static ImmutableTextEmail copyOf(TextEmail instance) {
        if (instance instanceof ImmutableTextEmail) {
            return (ImmutableTextEmail)instance;
        }
        return ImmutableTextEmail.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_EMAIL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText text;
        private String email;

        private Builder() {
        }

        public final Builder from(TextEmail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof TextEmail) {
                instance = (TextEmail)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.email(instance.email());
                this.text(instance.text());
            }
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTextEmail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextEmail(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build TextEmail, some of required attributes are not set " + attributes;
        }
    }
}

