/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextEmpty
implements TextEmpty {
    private final int identifier;
    private static final ImmutableTextEmpty INSTANCE = ImmutableTextEmpty.validate(new ImmutableTextEmpty());

    private ImmutableTextEmpty() {
        this.identifier = TextEmpty.super.identifier();
    }

    private ImmutableTextEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextEmpty.super.identifier();
    }

    private ImmutableTextEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableTextEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableTextEmpty.validate(new ImmutableTextEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextEmpty && this.equalTo(0, (ImmutableTextEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "TextEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableTextEmpty of() {
        return INSTANCE;
    }

    private static ImmutableTextEmpty validate(ImmutableTextEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableTextEmpty copyOf(TextEmpty instance) {
        if (instance instanceof ImmutableTextEmpty) {
            return (ImmutableTextEmpty)instance;
        }
        return ImmutableTextEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TextEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof TextEmpty) {
                instance = (TextEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableTextEmpty build() {
            return ImmutableTextEmpty.validate(new ImmutableTextEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

