/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextFixed;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextFixed
implements TextFixed {
    private final int identifier;
    private final RichText text;

    private ImmutableTextFixed(RichText text) {
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = TextFixed.super.identifier();
    }

    private ImmutableTextFixed(Builder builder) {
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextFixed.super.identifier();
    }

    private ImmutableTextFixed(int identifier, RichText text) {
        this.identifier = identifier;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    public final ImmutableTextFixed withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextFixed(value, this.text);
    }

    public final ImmutableTextFixed withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutableTextFixed(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextFixed && this.equalTo(0, (ImmutableTextFixed)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextFixed another) {
        return this.identifier == another.identifier && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "TextFixed{identifier=" + this.identifier + ", text=" + this.text + "}";
    }

    public static ImmutableTextFixed of(RichText text) {
        return new ImmutableTextFixed(text);
    }

    public static ImmutableTextFixed copyOf(TextFixed instance) {
        if (instance instanceof ImmutableTextFixed) {
            return (ImmutableTextFixed)instance;
        }
        return ImmutableTextFixed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private RichText text;

        private Builder() {
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TextFixed instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TextFixed) {
                instance = (TextFixed)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTextFixed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextFixed(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build TextFixed, some of required attributes are not set " + attributes;
        }
    }
}

