/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextImage;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextImage
implements TextImage {
    private final int identifier;
    private final long documentId;
    private final int w;
    private final int h;

    private ImmutableTextImage(long documentId, int w, int h) {
        this.documentId = documentId;
        this.w = w;
        this.h = h;
        this.identifier = TextImage.super.identifier();
    }

    private ImmutableTextImage(Builder builder) {
        this.documentId = builder.documentId;
        this.w = builder.w;
        this.h = builder.h;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextImage.super.identifier();
    }

    private ImmutableTextImage(int identifier, long documentId, int w, int h) {
        this.identifier = identifier;
        this.documentId = documentId;
        this.w = w;
        this.h = h;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long documentId() {
        return this.documentId;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    public final ImmutableTextImage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextImage(value, this.documentId, this.w, this.h);
    }

    public final ImmutableTextImage withDocumentId(long value) {
        if (this.documentId == value) {
            return this;
        }
        return new ImmutableTextImage(this.identifier, value, this.w, this.h);
    }

    public final ImmutableTextImage withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutableTextImage(this.identifier, this.documentId, value, this.h);
    }

    public final ImmutableTextImage withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutableTextImage(this.identifier, this.documentId, this.w, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextImage && this.equalTo(0, (ImmutableTextImage)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextImage another) {
        return this.identifier == another.identifier && this.documentId == another.documentId && this.w == another.w && this.h == another.h;
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + Long.hashCode(this.documentId);
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        return h$$;
    }

    public String toString() {
        return "TextImage{identifier=" + this.identifier + ", documentId=" + this.documentId + ", w=" + this.w + ", h=" + this.h + "}";
    }

    public static ImmutableTextImage of(long documentId, int w, int h) {
        return new ImmutableTextImage(documentId, w, h);
    }

    public static ImmutableTextImage copyOf(TextImage instance) {
        if (instance instanceof ImmutableTextImage) {
            return (ImmutableTextImage)instance;
        }
        return ImmutableTextImage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOCUMENT_ID = 1L;
        private static final long INIT_BIT_W = 2L;
        private static final long INIT_BIT_H = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long documentId;
        private int w;
        private int h;

        private Builder() {
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TextImage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TextImage) {
                instance = (TextImage)object;
                this.h(instance.h());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.documentId(instance.documentId());
                this.w(instance.w());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder documentId(long documentId) {
            this.documentId = documentId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTextImage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextImage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("documentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("h");
            }
            return "Cannot build TextImage, some of required attributes are not set " + attributes;
        }
    }
}

