/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextPhone;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextPhone
implements TextPhone {
    private final int identifier;
    private final RichText text;
    private final String phone;

    private ImmutableTextPhone(RichText text, String phone) {
        this.text = Objects.requireNonNull(text, "text");
        this.phone = Objects.requireNonNull(phone, "phone");
        this.identifier = TextPhone.super.identifier();
    }

    private ImmutableTextPhone(Builder builder) {
        this.text = builder.text;
        this.phone = builder.phone;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextPhone.super.identifier();
    }

    private ImmutableTextPhone(int identifier, RichText text, String phone) {
        this.identifier = identifier;
        this.text = text;
        this.phone = phone;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    public final ImmutableTextPhone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextPhone(value, this.text, this.phone);
    }

    public final ImmutableTextPhone withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutableTextPhone(this.identifier, newValue, this.phone);
    }

    public final ImmutableTextPhone withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableTextPhone(this.identifier, this.text, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextPhone && this.equalTo(0, (ImmutableTextPhone)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextPhone another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.phone.equals(another.phone);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.phone.hashCode();
        return h;
    }

    public String toString() {
        return "TextPhone{identifier=" + this.identifier + ", text=" + this.text + ", phone=" + this.phone + "}";
    }

    public static ImmutableTextPhone of(RichText text, String phone) {
        return new ImmutableTextPhone(text, phone);
    }

    public static ImmutableTextPhone copyOf(TextPhone instance) {
        if (instance instanceof ImmutableTextPhone) {
            return (ImmutableTextPhone)instance;
        }
        return ImmutableTextPhone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_PHONE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private RichText text;
        private String phone;

        private Builder() {
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TextPhone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TextPhone) {
                instance = (TextPhone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phone(instance.phone());
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTextPhone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextPhone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phone");
            }
            return "Cannot build TextPhone, some of required attributes are not set " + attributes;
        }
    }
}

