/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.RichText;
import telegram4j.tl.TextUrl;
import telegram4j.tl.api.TlObject;

public final class ImmutableTextUrl
implements TextUrl {
    private final int identifier;
    private final RichText text;
    private final String url;
    private final long webpageId;

    private ImmutableTextUrl(RichText text, String url, long webpageId) {
        this.text = Objects.requireNonNull(text, "text");
        this.url = Objects.requireNonNull(url, "url");
        this.webpageId = webpageId;
        this.identifier = TextUrl.super.identifier();
    }

    private ImmutableTextUrl(Builder builder) {
        this.text = builder.text;
        this.url = builder.url;
        this.webpageId = builder.webpageId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TextUrl.super.identifier();
    }

    private ImmutableTextUrl(int identifier, RichText text, String url, long webpageId) {
        this.identifier = identifier;
        this.text = text;
        this.url = url;
        this.webpageId = webpageId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public RichText text() {
        return this.text;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public long webpageId() {
        return this.webpageId;
    }

    public final ImmutableTextUrl withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTextUrl(value, this.text, this.url, this.webpageId);
    }

    public final ImmutableTextUrl withText(RichText value) {
        if (this.text == value) {
            return this;
        }
        RichText newValue = Objects.requireNonNull(value, "text");
        return new ImmutableTextUrl(this.identifier, newValue, this.url, this.webpageId);
    }

    public final ImmutableTextUrl withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableTextUrl(this.identifier, this.text, newValue, this.webpageId);
    }

    public final ImmutableTextUrl withWebpageId(long value) {
        if (this.webpageId == value) {
            return this;
        }
        return new ImmutableTextUrl(this.identifier, this.text, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTextUrl && this.equalTo(0, (ImmutableTextUrl)another);
    }

    private boolean equalTo(int synthetic, ImmutableTextUrl another) {
        return this.identifier == another.identifier && this.text.equals(another.text) && this.url.equals(another.url) && this.webpageId == another.webpageId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Long.hashCode(this.webpageId);
        return h;
    }

    public String toString() {
        return "TextUrl{identifier=" + this.identifier + ", text=" + this.text + ", url=" + this.url + ", webpageId=" + this.webpageId + "}";
    }

    public static ImmutableTextUrl of(RichText text, String url, long webpageId) {
        return new ImmutableTextUrl(text, url, webpageId);
    }

    public static ImmutableTextUrl copyOf(TextUrl instance) {
        if (instance instanceof ImmutableTextUrl) {
            return (ImmutableTextUrl)instance;
        }
        return ImmutableTextUrl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_WEBPAGE_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private RichText text;
        private String url;
        private long webpageId;

        private Builder() {
        }

        public final Builder from(RichText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TextUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RichText instance;
            long bits = 0L;
            if (object instanceof RichText) {
                instance = (RichText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TextUrl) {
                instance = (TextUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.webpageId(instance.webpageId());
                this.text(instance.text());
                this.url(instance.url());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(RichText text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder webpageId(long webpageId) {
            this.webpageId = webpageId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTextUrl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTextUrl(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("webpageId");
            }
            return "Cannot build TextUrl, some of required attributes are not set " + attributes;
        }
    }
}

