/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Document;
import telegram4j.tl.Theme;
import telegram4j.tl.ThemeSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableTheme
implements Theme {
    private final int identifier;
    private final int flags;
    private final boolean creator;
    private final boolean isDefault;
    private final boolean forChat;
    private final long id;
    private final long accessHash;
    private final String slug;
    private final String title;
    @Nullable
    private final Document document;
    @Nullable
    private final List<ThemeSettings> settings;
    @Nullable
    private final String emoticon;
    @Nullable
    private final Integer installsCount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTheme(long id, long accessHash, String slug, String title) {
        this.id = id;
        this.accessHash = accessHash;
        this.slug = Objects.requireNonNull(slug, "slug");
        this.title = Objects.requireNonNull(title, "title");
        this.document = null;
        this.settings = null;
        this.emoticon = null;
        this.installsCount = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.isDefault = this.initShim.isDefault();
        this.forChat = this.initShim.forChat();
        this.initShim = null;
    }

    private ImmutableTheme(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.slug = builder.slug;
        this.title = builder.title;
        this.document = builder.document;
        this.settings = builder.settings == null ? null : ImmutableTheme.createUnmodifiableList(true, builder.settings);
        this.emoticon = builder.emoticon;
        this.installsCount = builder.installsCount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.creatorIsSet()) {
            this.initShim.creator(builder.creator);
        }
        if (builder.isDefaultIsSet()) {
            this.initShim.isDefault(builder.isDefault);
        }
        if (builder.forChatIsSet()) {
            this.initShim.forChat(builder.forChat);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.isDefault = this.initShim.isDefault();
        this.forChat = this.initShim.forChat();
        this.initShim = null;
    }

    private ImmutableTheme(int identifier, int flags, boolean creator, boolean isDefault, boolean forChat, long id, long accessHash, String slug, String title, @Nullable Document document, @Nullable List<ThemeSettings> settings, @Nullable String emoticon, @Nullable Integer installsCount) {
        this.identifier = identifier;
        this.flags = flags;
        this.creator = creator;
        this.isDefault = isDefault;
        this.forChat = forChat;
        this.id = id;
        this.accessHash = accessHash;
        this.slug = slug;
        this.title = title;
        this.document = document;
        this.settings = settings;
        this.emoticon = emoticon;
        this.installsCount = installsCount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Theme.super.identifier();
    }

    private int flagsInitialize() {
        return Theme.super.flags();
    }

    private boolean creatorInitialize() {
        return Theme.super.creator();
    }

    private boolean isDefaultInitialize() {
        return Theme.super.isDefault();
    }

    private boolean forChatInitialize() {
        return Theme.super.forChat();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean creator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creator() : this.creator;
    }

    @Override
    public boolean isDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDefault() : this.isDefault;
    }

    @Override
    public boolean forChat() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forChat() : this.forChat;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public Document document() {
        return this.document;
    }

    @Override
    @Nullable
    public List<ThemeSettings> settings() {
        return this.settings;
    }

    @Override
    @Nullable
    public String emoticon() {
        return this.emoticon;
    }

    @Override
    @Nullable
    public Integer installsCount() {
        return this.installsCount;
    }

    public final ImmutableTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTheme(value, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, value, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withCreator(boolean value) {
        if (this.creator == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, value, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withIsDefault(boolean value) {
        if (this.isDefault == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, value, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withForChat(boolean value) {
        if (this.forChat == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, value, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, value, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, value, this.slug, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, newValue, this.title, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, newValue, this.document, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withDocument(@Nullable Document value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, value, this.settings, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withSettings(ThemeSettings ... elements) {
        if (elements == null) {
            return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, null, this.emoticon, this.installsCount);
        }
        List<ThemeSettings> newValue = Arrays.asList(elements) == null ? null : ImmutableTheme.createUnmodifiableList(false, ImmutableTheme.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, newValue, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withSettings(@Nullable Iterable<? extends ThemeSettings> elements) {
        if (this.settings == elements) {
            return this;
        }
        List<ThemeSettings> newValue = elements == null ? null : ImmutableTheme.createUnmodifiableList(false, ImmutableTheme.createSafeList(elements, true, false));
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, newValue, this.emoticon, this.installsCount);
    }

    public final ImmutableTheme withEmoticon(@Nullable String value) {
        if (Objects.equals(this.emoticon, value)) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, value, this.installsCount);
    }

    public final ImmutableTheme withInstallsCount(@Nullable Integer value) {
        if (Objects.equals(this.installsCount, value)) {
            return this;
        }
        return new ImmutableTheme(this.identifier, this.flags, this.creator, this.isDefault, this.forChat, this.id, this.accessHash, this.slug, this.title, this.document, this.settings, this.emoticon, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTheme && this.equalTo(0, (ImmutableTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableTheme another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.creator == another.creator && this.isDefault == another.isDefault && this.forChat == another.forChat && this.id == another.id && this.accessHash == another.accessHash && this.slug.equals(another.slug) && this.title.equals(another.title) && Objects.equals(this.document, another.document) && Objects.equals(this.settings, another.settings) && Objects.equals(this.emoticon, another.emoticon) && Objects.equals(this.installsCount, another.installsCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.creator);
        h += (h << 5) + Boolean.hashCode(this.isDefault);
        h += (h << 5) + Boolean.hashCode(this.forChat);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.slug.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.settings);
        h += (h << 5) + Objects.hashCode(this.emoticon);
        h += (h << 5) + Objects.hashCode(this.installsCount);
        return h;
    }

    public String toString() {
        return "Theme{identifier=" + this.identifier + ", flags=" + this.flags + ", creator=" + this.creator + ", isDefault=" + this.isDefault + ", forChat=" + this.forChat + ", id=" + this.id + ", accessHash=" + this.accessHash + ", slug=" + this.slug + ", title=" + this.title + ", document=" + this.document + ", settings=" + this.settings + ", emoticon=" + this.emoticon + ", installsCount=" + this.installsCount + "}";
    }

    public static ImmutableTheme of(long id, long accessHash, String slug, String title) {
        return new ImmutableTheme(id, accessHash, slug, title);
    }

    public static ImmutableTheme copyOf(Theme instance) {
        if (instance instanceof ImmutableTheme) {
            return (ImmutableTheme)instance;
        }
        return ImmutableTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_SLUG = 4L;
        private static final long INIT_BIT_TITLE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CREATOR = 4L;
        private static final long OPT_BIT_IS_DEFAULT = 8L;
        private static final long OPT_BIT_FOR_CHAT = 16L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean creator;
        private boolean isDefault;
        private boolean forChat;
        private long id;
        private long accessHash;
        private String slug;
        private String title;
        private Document document;
        private List<ThemeSettings> settings = null;
        private String emoticon;
        private Integer installsCount;

        private Builder() {
        }

        public final Builder from(Theme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Theme instance;
            long bits = 0L;
            if (object instanceof Theme) {
                List<ThemeSettings> settingsValue;
                instance = (Theme)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((settingsValue = instance.settings()) != null) {
                    this.addAllSettings(settingsValue);
                }
                this.creator(instance.creator());
                Document documentValue = instance.document();
                if (documentValue != null) {
                    this.document(documentValue);
                }
                this.flags(instance.flags());
                this.title(instance.title());
                this.forChat(instance.forChat());
                this.isDefault(instance.isDefault());
                Integer installsCountValue = instance.installsCount();
                if (installsCountValue != null) {
                    this.installsCount(installsCountValue);
                }
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                String emoticonValue = instance.emoticon();
                if (emoticonValue != null) {
                    this.emoticon(emoticonValue);
                }
                this.slug(instance.slug());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder creator(boolean creator) {
            this.creator = creator;
            this.optBits |= 4L;
            return this;
        }

        public final Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.optBits |= 8L;
            return this;
        }

        public final Builder forChat(boolean forChat) {
            this.forChat = forChat;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder document(@Nullable Document document) {
            this.document = document;
            return this;
        }

        public final Builder addSetting(ThemeSettings element) {
            if (this.settings == null) {
                this.settings = new ArrayList<ThemeSettings>();
            }
            this.settings.add(Objects.requireNonNull(element, "settings element"));
            return this;
        }

        public final Builder addSettings(ThemeSettings ... elements) {
            if (this.settings == null) {
                this.settings = new ArrayList<ThemeSettings>();
            }
            for (ThemeSettings element : elements) {
                this.settings.add(Objects.requireNonNull(element, "settings element"));
            }
            return this;
        }

        public final Builder settings(@Nullable Iterable<? extends ThemeSettings> elements) {
            if (elements == null) {
                this.settings = null;
                return this;
            }
            this.settings = new ArrayList<ThemeSettings>();
            return this.addAllSettings(elements);
        }

        public final Builder addAllSettings(Iterable<? extends ThemeSettings> elements) {
            Objects.requireNonNull(elements, "settings element");
            if (this.settings == null) {
                this.settings = new ArrayList<ThemeSettings>();
            }
            for (ThemeSettings themeSettings : elements) {
                this.settings.add(Objects.requireNonNull(themeSettings, "settings element"));
            }
            return this;
        }

        public final Builder emoticon(@Nullable String emoticon) {
            this.emoticon = emoticon;
            return this;
        }

        public final Builder installsCount(@Nullable Integer installsCount) {
            this.installsCount = installsCount;
            return this;
        }

        public ImmutableTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean creatorIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean isDefaultIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean forChatIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("slug");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build Theme, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte creatorBuildStage = 0;
        private boolean creator;
        private byte isDefaultBuildStage = 0;
        private boolean isDefault;
        private byte forChatBuildStage = 0;
        private boolean forChat;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableTheme.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableTheme.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean creator() {
            if (this.creatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creatorBuildStage == 0) {
                this.creatorBuildStage = (byte)-1;
                this.creator = ImmutableTheme.this.creatorInitialize();
                this.creatorBuildStage = 1;
            }
            return this.creator;
        }

        void creator(boolean creator) {
            this.creator = creator;
            this.creatorBuildStage = 1;
        }

        boolean isDefault() {
            if (this.isDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDefaultBuildStage == 0) {
                this.isDefaultBuildStage = (byte)-1;
                this.isDefault = ImmutableTheme.this.isDefaultInitialize();
                this.isDefaultBuildStage = 1;
            }
            return this.isDefault;
        }

        void isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.isDefaultBuildStage = 1;
        }

        boolean forChat() {
            if (this.forChatBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forChatBuildStage == 0) {
                this.forChatBuildStage = (byte)-1;
                this.forChat = ImmutableTheme.this.forChatInitialize();
                this.forChatBuildStage = 1;
            }
            return this.forChat;
        }

        void forChat(boolean forChat) {
            this.forChat = forChat;
            this.forChatBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.creatorBuildStage == -1) {
                attributes.add("creator");
            }
            if (this.isDefaultBuildStage == -1) {
                attributes.add("isDefault");
            }
            if (this.forChatBuildStage == -1) {
                attributes.add("forChat");
            }
            return "Cannot build Theme, attribute initializers form cycle " + attributes;
        }
    }
}

