/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseTheme;
import telegram4j.tl.ThemeSettings;
import telegram4j.tl.WallPaper;
import telegram4j.tl.api.TlObject;

public final class ImmutableThemeSettings
implements ThemeSettings {
    private final int identifier;
    private final int flags;
    private final boolean messageColorsAnimated;
    private final BaseTheme baseTheme;
    private final int accentColor;
    @Nullable
    private final Integer outboxAccentColor;
    @Nullable
    private final List<Integer> messageColors;
    @Nullable
    private final WallPaper wallpaper;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableThemeSettings(BaseTheme baseTheme, int accentColor) {
        this.baseTheme = Objects.requireNonNull(baseTheme, "baseTheme");
        this.accentColor = accentColor;
        this.outboxAccentColor = null;
        this.messageColors = null;
        this.wallpaper = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.messageColorsAnimated = this.initShim.messageColorsAnimated();
        this.initShim = null;
    }

    private ImmutableThemeSettings(Builder builder) {
        this.baseTheme = builder.baseTheme;
        this.accentColor = builder.accentColor;
        this.outboxAccentColor = builder.outboxAccentColor;
        this.messageColors = builder.messageColors == null ? null : ImmutableThemeSettings.createUnmodifiableList(true, builder.messageColors);
        this.wallpaper = builder.wallpaper;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.messageColorsAnimatedIsSet()) {
            this.initShim.messageColorsAnimated(builder.messageColorsAnimated);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.messageColorsAnimated = this.initShim.messageColorsAnimated();
        this.initShim = null;
    }

    private ImmutableThemeSettings(int identifier, int flags, boolean messageColorsAnimated, BaseTheme baseTheme, int accentColor, @Nullable Integer outboxAccentColor, @Nullable List<Integer> messageColors, @Nullable WallPaper wallpaper) {
        this.identifier = identifier;
        this.flags = flags;
        this.messageColorsAnimated = messageColorsAnimated;
        this.baseTheme = baseTheme;
        this.accentColor = accentColor;
        this.outboxAccentColor = outboxAccentColor;
        this.messageColors = messageColors;
        this.wallpaper = wallpaper;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ThemeSettings.super.identifier();
    }

    private int flagsInitialize() {
        return ThemeSettings.super.flags();
    }

    private boolean messageColorsAnimatedInitialize() {
        return ThemeSettings.super.messageColorsAnimated();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean messageColorsAnimated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messageColorsAnimated() : this.messageColorsAnimated;
    }

    @Override
    public BaseTheme baseTheme() {
        return this.baseTheme;
    }

    @Override
    public int accentColor() {
        return this.accentColor;
    }

    @Override
    @Nullable
    public Integer outboxAccentColor() {
        return this.outboxAccentColor;
    }

    @Override
    @Nullable
    public List<Integer> messageColors() {
        return this.messageColors;
    }

    @Override
    @Nullable
    public WallPaper wallpaper() {
        return this.wallpaper;
    }

    public final ImmutableThemeSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableThemeSettings(value, this.flags, this.messageColorsAnimated, this.baseTheme, this.accentColor, this.outboxAccentColor, this.messageColors, this.wallpaper);
    }

    public final ImmutableThemeSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableThemeSettings(this.identifier, value, this.messageColorsAnimated, this.baseTheme, this.accentColor, this.outboxAccentColor, this.messageColors, this.wallpaper);
    }

    public final ImmutableThemeSettings withMessageColorsAnimated(boolean value) {
        if (this.messageColorsAnimated == value) {
            return this;
        }
        return new ImmutableThemeSettings(this.identifier, this.flags, value, this.baseTheme, this.accentColor, this.outboxAccentColor, this.messageColors, this.wallpaper);
    }

    public final ImmutableThemeSettings withBaseTheme(BaseTheme value) {
        BaseTheme newValue = Objects.requireNonNull(value, "baseTheme");
        if (this.baseTheme == newValue) {
            return this;
        }
        return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, newValue, this.accentColor, this.outboxAccentColor, this.messageColors, this.wallpaper);
    }

    public final ImmutableThemeSettings withAccentColor(int value) {
        if (this.accentColor == value) {
            return this;
        }
        return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, this.baseTheme, value, this.outboxAccentColor, this.messageColors, this.wallpaper);
    }

    public final ImmutableThemeSettings withOutboxAccentColor(@Nullable Integer value) {
        if (Objects.equals(this.outboxAccentColor, value)) {
            return this;
        }
        return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, this.baseTheme, this.accentColor, value, this.messageColors, this.wallpaper);
    }

    public final ImmutableThemeSettings withMessageColors(int ... elements) {
        if (elements == null) {
            return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, this.baseTheme, this.accentColor, this.outboxAccentColor, null, this.wallpaper);
        }
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableThemeSettings.createUnmodifiableList(false, wrappedList);
        return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, this.baseTheme, this.accentColor, this.outboxAccentColor, newValue, this.wallpaper);
    }

    public final ImmutableThemeSettings withMessageColors(@Nullable Iterable<Integer> elements) {
        if (this.messageColors == elements) {
            return this;
        }
        List<Integer> newValue = elements == null ? null : ImmutableThemeSettings.createUnmodifiableList(false, ImmutableThemeSettings.createSafeList(elements, true, false));
        return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, this.baseTheme, this.accentColor, this.outboxAccentColor, newValue, this.wallpaper);
    }

    public final ImmutableThemeSettings withWallpaper(@Nullable WallPaper value) {
        if (this.wallpaper == value) {
            return this;
        }
        return new ImmutableThemeSettings(this.identifier, this.flags, this.messageColorsAnimated, this.baseTheme, this.accentColor, this.outboxAccentColor, this.messageColors, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThemeSettings && this.equalTo(0, (ImmutableThemeSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableThemeSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.messageColorsAnimated == another.messageColorsAnimated && this.baseTheme.equals((Object)another.baseTheme) && this.accentColor == another.accentColor && Objects.equals(this.outboxAccentColor, another.outboxAccentColor) && Objects.equals(this.messageColors, another.messageColors) && Objects.equals(this.wallpaper, another.wallpaper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.messageColorsAnimated);
        h += (h << 5) + this.baseTheme.hashCode();
        h += (h << 5) + this.accentColor;
        h += (h << 5) + Objects.hashCode(this.outboxAccentColor);
        h += (h << 5) + Objects.hashCode(this.messageColors);
        h += (h << 5) + Objects.hashCode(this.wallpaper);
        return h;
    }

    public String toString() {
        return "ThemeSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", messageColorsAnimated=" + this.messageColorsAnimated + ", baseTheme=" + this.baseTheme + ", accentColor=" + this.accentColor + ", outboxAccentColor=" + this.outboxAccentColor + ", messageColors=" + this.messageColors + ", wallpaper=" + this.wallpaper + "}";
    }

    public static ImmutableThemeSettings of(BaseTheme baseTheme, int accentColor) {
        return new ImmutableThemeSettings(baseTheme, accentColor);
    }

    public static ImmutableThemeSettings copyOf(ThemeSettings instance) {
        if (instance instanceof ImmutableThemeSettings) {
            return (ImmutableThemeSettings)instance;
        }
        return ImmutableThemeSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_BASE_THEME = 1L;
        private static final long INIT_BIT_ACCENT_COLOR = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MESSAGE_COLORS_ANIMATED = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean messageColorsAnimated;
        private BaseTheme baseTheme;
        private int accentColor;
        private Integer outboxAccentColor;
        private List<Integer> messageColors = null;
        private WallPaper wallpaper;

        private Builder() {
        }

        public final Builder from(ThemeSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ThemeSettings instance;
            long bits = 0L;
            if (object instanceof ThemeSettings) {
                Integer outboxAccentColorValue;
                instance = (ThemeSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.messageColorsAnimated(instance.messageColorsAnimated());
                this.baseTheme(instance.baseTheme());
                WallPaper wallpaperValue = instance.wallpaper();
                if (wallpaperValue != null) {
                    this.wallpaper(wallpaperValue);
                }
                this.accentColor(instance.accentColor());
                this.flags(instance.flags());
                List<Integer> messageColorsValue = instance.messageColors();
                if (messageColorsValue != null) {
                    this.addAllMessageColors(messageColorsValue);
                }
                if ((outboxAccentColorValue = instance.outboxAccentColor()) != null) {
                    this.outboxAccentColor(outboxAccentColorValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder messageColorsAnimated(boolean messageColorsAnimated) {
            this.messageColorsAnimated = messageColorsAnimated;
            this.optBits |= 4L;
            return this;
        }

        public final Builder baseTheme(BaseTheme baseTheme) {
            this.baseTheme = Objects.requireNonNull(baseTheme, "baseTheme");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accentColor(int accentColor) {
            this.accentColor = accentColor;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder outboxAccentColor(@Nullable Integer outboxAccentColor) {
            this.outboxAccentColor = outboxAccentColor;
            return this;
        }

        public final Builder addMessageColor(int element) {
            if (this.messageColors == null) {
                this.messageColors = new ArrayList<Integer>();
            }
            this.messageColors.add(element);
            return this;
        }

        public final Builder addMessageColors(int ... elements) {
            if (this.messageColors == null) {
                this.messageColors = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.messageColors.add(element);
            }
            return this;
        }

        public final Builder messageColors(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.messageColors = null;
                return this;
            }
            this.messageColors = new ArrayList<Integer>();
            return this.addAllMessageColors(elements);
        }

        public final Builder addAllMessageColors(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "messageColors element");
            if (this.messageColors == null) {
                this.messageColors = new ArrayList<Integer>();
            }
            for (Integer element : elements) {
                this.messageColors.add(Objects.requireNonNull(element, "messageColors element"));
            }
            return this;
        }

        public final Builder wallpaper(@Nullable WallPaper wallpaper) {
            this.wallpaper = wallpaper;
            return this;
        }

        public ImmutableThemeSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThemeSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean messageColorsAnimatedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("baseTheme");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accentColor");
            }
            return "Cannot build ThemeSettings, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte messageColorsAnimatedBuildStage = 0;
        private boolean messageColorsAnimated;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableThemeSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableThemeSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean messageColorsAnimated() {
            if (this.messageColorsAnimatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageColorsAnimatedBuildStage == 0) {
                this.messageColorsAnimatedBuildStage = (byte)-1;
                this.messageColorsAnimated = ImmutableThemeSettings.this.messageColorsAnimatedInitialize();
                this.messageColorsAnimatedBuildStage = 1;
            }
            return this.messageColorsAnimated;
        }

        void messageColorsAnimated(boolean messageColorsAnimated) {
            this.messageColorsAnimated = messageColorsAnimated;
            this.messageColorsAnimatedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.messageColorsAnimatedBuildStage == -1) {
                attributes.add("messageColorsAnimated");
            }
            return "Cannot build ThemeSettings, attribute initializers form cycle " + attributes;
        }
    }
}

