/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.TopPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableTopPeer
implements TopPeer {
    private final int identifier;
    private final Peer peer;
    private final double rating;

    private ImmutableTopPeer(Peer peer, double rating) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.rating = rating;
        this.identifier = TopPeer.super.identifier();
    }

    private ImmutableTopPeer(Builder builder) {
        this.peer = builder.peer;
        this.rating = builder.rating;
        this.identifier = builder.identifierIsSet() ? builder.identifier : TopPeer.super.identifier();
    }

    private ImmutableTopPeer(int identifier, Peer peer, double rating) {
        this.identifier = identifier;
        this.peer = peer;
        this.rating = rating;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public double rating() {
        return this.rating;
    }

    public final ImmutableTopPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTopPeer(value, this.peer, this.rating);
    }

    public final ImmutableTopPeer withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableTopPeer(this.identifier, newValue, this.rating);
    }

    public final ImmutableTopPeer withRating(double value) {
        if (Double.doubleToLongBits(this.rating) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableTopPeer(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTopPeer && this.equalTo(0, (ImmutableTopPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableTopPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && Double.doubleToLongBits(this.rating) == Double.doubleToLongBits(another.rating);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Double.hashCode(this.rating);
        return h;
    }

    public String toString() {
        return "TopPeer{identifier=" + this.identifier + ", peer=" + this.peer + ", rating=" + this.rating + "}";
    }

    public static ImmutableTopPeer of(Peer peer, double rating) {
        return new ImmutableTopPeer(peer, rating);
    }

    public static ImmutableTopPeer copyOf(TopPeer instance) {
        if (instance instanceof ImmutableTopPeer) {
            return (ImmutableTopPeer)instance;
        }
        return ImmutableTopPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_RATING = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private double rating;

        private Builder() {
        }

        public final Builder from(TopPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TopPeer instance;
            long bits = 0L;
            if (object instanceof TopPeer) {
                instance = (TopPeer)object;
                this.rating(instance.rating());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rating(double rating) {
            this.rating = rating;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTopPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTopPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rating");
            }
            return "Cannot build TopPeer, some of required attributes are not set " + attributes;
        }
    }
}

