/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.TopPeer;
import telegram4j.tl.TopPeerCategory;
import telegram4j.tl.TopPeerCategoryPeers;
import telegram4j.tl.api.TlObject;

public final class ImmutableTopPeerCategoryPeers
implements TopPeerCategoryPeers {
    private final int identifier;
    private final TopPeerCategory category;
    private final int count;
    private final List<TopPeer> peers;

    private ImmutableTopPeerCategoryPeers(TopPeerCategory category, int count) {
        this.category = Objects.requireNonNull(category, "category");
        this.count = count;
        this.peers = Collections.emptyList();
        this.identifier = TopPeerCategoryPeers.super.identifier();
    }

    private ImmutableTopPeerCategoryPeers(Builder builder) {
        this.category = builder.category;
        this.count = builder.count;
        this.peers = ImmutableTopPeerCategoryPeers.createUnmodifiableList(true, builder.peers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : TopPeerCategoryPeers.super.identifier();
    }

    private ImmutableTopPeerCategoryPeers(int identifier, TopPeerCategory category, int count, List<TopPeer> peers) {
        this.identifier = identifier;
        this.category = category;
        this.count = count;
        this.peers = peers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public TopPeerCategory category() {
        return this.category;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<TopPeer> peers() {
        return this.peers;
    }

    public final ImmutableTopPeerCategoryPeers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTopPeerCategoryPeers(value, this.category, this.count, this.peers);
    }

    public final ImmutableTopPeerCategoryPeers withCategory(TopPeerCategory value) {
        TopPeerCategory newValue = Objects.requireNonNull(value, "category");
        if (this.category == newValue) {
            return this;
        }
        return new ImmutableTopPeerCategoryPeers(this.identifier, newValue, this.count, this.peers);
    }

    public final ImmutableTopPeerCategoryPeers withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableTopPeerCategoryPeers(this.identifier, this.category, value, this.peers);
    }

    public final ImmutableTopPeerCategoryPeers withPeers(TopPeer ... elements) {
        List<TopPeer> newValue = ImmutableTopPeerCategoryPeers.createUnmodifiableList(false, ImmutableTopPeerCategoryPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTopPeerCategoryPeers(this.identifier, this.category, this.count, newValue);
    }

    public final ImmutableTopPeerCategoryPeers withPeers(Iterable<? extends TopPeer> elements) {
        if (this.peers == elements) {
            return this;
        }
        List<TopPeer> newValue = ImmutableTopPeerCategoryPeers.createUnmodifiableList(false, ImmutableTopPeerCategoryPeers.createSafeList(elements, true, false));
        return new ImmutableTopPeerCategoryPeers(this.identifier, this.category, this.count, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTopPeerCategoryPeers && this.equalTo(0, (ImmutableTopPeerCategoryPeers)another);
    }

    private boolean equalTo(int synthetic, ImmutableTopPeerCategoryPeers another) {
        return this.identifier == another.identifier && this.category.equals((Object)another.category) && this.count == another.count && this.peers.equals(another.peers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.category.hashCode();
        h += (h << 5) + this.count;
        h += (h << 5) + this.peers.hashCode();
        return h;
    }

    public String toString() {
        return "TopPeerCategoryPeers{identifier=" + this.identifier + ", category=" + this.category + ", count=" + this.count + ", peers=" + this.peers + "}";
    }

    public static ImmutableTopPeerCategoryPeers of(TopPeerCategory category, int count) {
        return new ImmutableTopPeerCategoryPeers(category, count);
    }

    public static ImmutableTopPeerCategoryPeers copyOf(TopPeerCategoryPeers instance) {
        if (instance instanceof ImmutableTopPeerCategoryPeers) {
            return (ImmutableTopPeerCategoryPeers)instance;
        }
        return ImmutableTopPeerCategoryPeers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CATEGORY = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private TopPeerCategory category;
        private int count;
        private List<TopPeer> peers = new ArrayList<TopPeer>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TopPeerCategoryPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TopPeerCategoryPeers) {
                instance = (TopPeerCategoryPeers)object;
                this.count(instance.count());
                this.addAllPeers(instance.peers());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.category(instance.category());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder category(TopPeerCategory category) {
            this.category = Objects.requireNonNull(category, "category");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPeer(TopPeer element) {
            this.peers.add(Objects.requireNonNull(element, "peers element"));
            return this;
        }

        public final Builder addPeers(TopPeer ... elements) {
            for (TopPeer element : elements) {
                this.peers.add(Objects.requireNonNull(element, "peers element"));
            }
            return this;
        }

        public final Builder peers(Iterable<? extends TopPeer> elements) {
            this.peers.clear();
            return this.addAllPeers(elements);
        }

        public final Builder addAllPeers(Iterable<? extends TopPeer> elements) {
            for (TopPeer topPeer : elements) {
                this.peers.add(Objects.requireNonNull(topPeer, "peers element"));
            }
            return this;
        }

        public ImmutableTopPeerCategoryPeers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTopPeerCategoryPeers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("category");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build TopPeerCategoryPeers, some of required attributes are not set " + attributes;
        }
    }
}

