/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotChatInviteRequester;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotChatInviteRequester
implements UpdateBotChatInviteRequester {
    private final int identifier;
    private final Peer peer;
    private final int date;
    private final long userId;
    private final String about;
    private final ExportedChatInvite invite;
    private final int qts;

    private ImmutableUpdateBotChatInviteRequester(Peer peer, int date, long userId, String about, ExportedChatInvite invite, int qts) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.date = date;
        this.userId = userId;
        this.about = Objects.requireNonNull(about, "about");
        this.invite = Objects.requireNonNull(invite, "invite");
        this.qts = qts;
        this.identifier = UpdateBotChatInviteRequester.super.identifier();
    }

    private ImmutableUpdateBotChatInviteRequester(Builder builder) {
        this.peer = builder.peer;
        this.date = builder.date;
        this.userId = builder.userId;
        this.about = builder.about;
        this.invite = builder.invite;
        this.qts = builder.qts;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateBotChatInviteRequester.super.identifier();
    }

    private ImmutableUpdateBotChatInviteRequester(int identifier, Peer peer, int date, long userId, String about, ExportedChatInvite invite, int qts) {
        this.identifier = identifier;
        this.peer = peer;
        this.date = date;
        this.userId = userId;
        this.about = about;
        this.invite = invite;
        this.qts = qts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public String about() {
        return this.about;
    }

    @Override
    public ExportedChatInvite invite() {
        return this.invite;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableUpdateBotChatInviteRequester withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotChatInviteRequester(value, this.peer, this.date, this.userId, this.about, this.invite, this.qts);
    }

    public final ImmutableUpdateBotChatInviteRequester withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateBotChatInviteRequester(this.identifier, newValue, this.date, this.userId, this.about, this.invite, this.qts);
    }

    public final ImmutableUpdateBotChatInviteRequester withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateBotChatInviteRequester(this.identifier, this.peer, value, this.userId, this.about, this.invite, this.qts);
    }

    public final ImmutableUpdateBotChatInviteRequester withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateBotChatInviteRequester(this.identifier, this.peer, this.date, value, this.about, this.invite, this.qts);
    }

    public final ImmutableUpdateBotChatInviteRequester withAbout(String value) {
        String newValue = Objects.requireNonNull(value, "about");
        if (this.about.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateBotChatInviteRequester(this.identifier, this.peer, this.date, this.userId, newValue, this.invite, this.qts);
    }

    public final ImmutableUpdateBotChatInviteRequester withInvite(ExportedChatInvite value) {
        if (this.invite == value) {
            return this;
        }
        ExportedChatInvite newValue = Objects.requireNonNull(value, "invite");
        return new ImmutableUpdateBotChatInviteRequester(this.identifier, this.peer, this.date, this.userId, this.about, newValue, this.qts);
    }

    public final ImmutableUpdateBotChatInviteRequester withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableUpdateBotChatInviteRequester(this.identifier, this.peer, this.date, this.userId, this.about, this.invite, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotChatInviteRequester && this.equalTo(0, (ImmutableUpdateBotChatInviteRequester)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotChatInviteRequester another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.date == another.date && this.userId == another.userId && this.about.equals(another.about) && this.invite.equals(another.invite) && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.about.hashCode();
        h += (h << 5) + this.invite.hashCode();
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "UpdateBotChatInviteRequester{identifier=" + this.identifier + ", peer=" + this.peer + ", date=" + this.date + ", userId=" + this.userId + ", about=" + this.about + ", invite=" + this.invite + ", qts=" + this.qts + "}";
    }

    public static ImmutableUpdateBotChatInviteRequester of(Peer peer, int date, long userId, String about, ExportedChatInvite invite, int qts) {
        return new ImmutableUpdateBotChatInviteRequester(peer, date, userId, about, invite, qts);
    }

    public static ImmutableUpdateBotChatInviteRequester copyOf(UpdateBotChatInviteRequester instance) {
        if (instance instanceof ImmutableUpdateBotChatInviteRequester) {
            return (ImmutableUpdateBotChatInviteRequester)instance;
        }
        return ImmutableUpdateBotChatInviteRequester.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long INIT_BIT_ABOUT = 8L;
        private static final long INIT_BIT_INVITE = 16L;
        private static final long INIT_BIT_QTS = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private int date;
        private long userId;
        private String about;
        private ExportedChatInvite invite;
        private int qts;

        private Builder() {
        }

        public final Builder from(UpdateBotChatInviteRequester instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateBotChatInviteRequester) {
                instance = (UpdateBotChatInviteRequester)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.qts(instance.qts());
                this.peer(instance.peer());
                this.about(instance.about());
                this.invite(instance.invite());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder about(String about) {
            this.about = Objects.requireNonNull(about, "about");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder invite(ExportedChatInvite invite) {
            this.invite = Objects.requireNonNull(invite, "invite");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableUpdateBotChatInviteRequester build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotChatInviteRequester(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("about");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("invite");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build UpdateBotChatInviteRequester, some of required attributes are not set " + attributes;
        }
    }
}

