/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BotCommand;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotCommands;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotCommands
implements UpdateBotCommands {
    private final int identifier;
    private final Peer peer;
    private final long botId;
    private final List<BotCommand> commands;

    private ImmutableUpdateBotCommands(Peer peer, long botId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.botId = botId;
        this.commands = Collections.emptyList();
        this.identifier = UpdateBotCommands.super.identifier();
    }

    private ImmutableUpdateBotCommands(Builder builder) {
        this.peer = builder.peer;
        this.botId = builder.botId;
        this.commands = ImmutableUpdateBotCommands.createUnmodifiableList(true, builder.commands);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateBotCommands.super.identifier();
    }

    private ImmutableUpdateBotCommands(int identifier, Peer peer, long botId, List<BotCommand> commands) {
        this.identifier = identifier;
        this.peer = peer;
        this.botId = botId;
        this.commands = commands;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public List<BotCommand> commands() {
        return this.commands;
    }

    public final ImmutableUpdateBotCommands withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotCommands(value, this.peer, this.botId, this.commands);
    }

    public final ImmutableUpdateBotCommands withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateBotCommands(this.identifier, newValue, this.botId, this.commands);
    }

    public final ImmutableUpdateBotCommands withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutableUpdateBotCommands(this.identifier, this.peer, value, this.commands);
    }

    public final ImmutableUpdateBotCommands withCommands(BotCommand ... elements) {
        List<BotCommand> newValue = ImmutableUpdateBotCommands.createUnmodifiableList(false, ImmutableUpdateBotCommands.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateBotCommands(this.identifier, this.peer, this.botId, newValue);
    }

    public final ImmutableUpdateBotCommands withCommands(Iterable<? extends BotCommand> elements) {
        if (this.commands == elements) {
            return this;
        }
        List<BotCommand> newValue = ImmutableUpdateBotCommands.createUnmodifiableList(false, ImmutableUpdateBotCommands.createSafeList(elements, true, false));
        return new ImmutableUpdateBotCommands(this.identifier, this.peer, this.botId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotCommands && this.equalTo(0, (ImmutableUpdateBotCommands)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotCommands another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.botId == another.botId && this.commands.equals(another.commands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.commands.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateBotCommands{identifier=" + this.identifier + ", peer=" + this.peer + ", botId=" + this.botId + ", commands=" + this.commands + "}";
    }

    public static ImmutableUpdateBotCommands of(Peer peer, long botId) {
        return new ImmutableUpdateBotCommands(peer, botId);
    }

    public static ImmutableUpdateBotCommands copyOf(UpdateBotCommands instance) {
        if (instance instanceof ImmutableUpdateBotCommands) {
            return (ImmutableUpdateBotCommands)instance;
        }
        return ImmutableUpdateBotCommands.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_BOT_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private long botId;
        private List<BotCommand> commands = new ArrayList<BotCommand>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateBotCommands instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateBotCommands) {
                instance = (UpdateBotCommands)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botId(instance.botId());
                this.peer(instance.peer());
                this.addAllCommands(instance.commands());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addCommand(BotCommand element) {
            this.commands.add(Objects.requireNonNull(element, "commands element"));
            return this;
        }

        public final Builder addCommands(BotCommand ... elements) {
            for (BotCommand element : elements) {
                this.commands.add(Objects.requireNonNull(element, "commands element"));
            }
            return this;
        }

        public final Builder commands(Iterable<? extends BotCommand> elements) {
            this.commands.clear();
            return this.addAllCommands(elements);
        }

        public final Builder addAllCommands(Iterable<? extends BotCommand> elements) {
            for (BotCommand botCommand : elements) {
                this.commands.add(Objects.requireNonNull(botCommand, "commands element"));
            }
            return this;
        }

        public ImmutableUpdateBotCommands build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotCommands(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("botId");
            }
            return "Cannot build UpdateBotCommands, some of required attributes are not set " + attributes;
        }
    }
}

