/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.InlineQueryPeerType;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotInlineQuery;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotInlineQuery
implements UpdateBotInlineQuery {
    private final int identifier;
    private final int flags;
    private final long queryId;
    private final long userId;
    private final String query;
    @Nullable
    private final GeoPoint geo;
    @Nullable
    private final InlineQueryPeerType peerType;
    private final String offset;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateBotInlineQuery(long queryId, long userId, String query, String offset) {
        this.queryId = queryId;
        this.userId = userId;
        this.query = Objects.requireNonNull(query, "query");
        this.offset = Objects.requireNonNull(offset, "offset");
        this.geo = null;
        this.peerType = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateBotInlineQuery(Builder builder) {
        this.queryId = builder.queryId;
        this.userId = builder.userId;
        this.query = builder.query;
        this.geo = builder.geo;
        this.peerType = builder.peerType;
        this.offset = builder.offset;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateBotInlineQuery(int identifier, int flags, long queryId, long userId, String query, @Nullable GeoPoint geo, @Nullable InlineQueryPeerType peerType, String offset) {
        this.identifier = identifier;
        this.flags = flags;
        this.queryId = queryId;
        this.userId = userId;
        this.query = query;
        this.geo = geo;
        this.peerType = peerType;
        this.offset = offset;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateBotInlineQuery.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateBotInlineQuery.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    @Nullable
    public GeoPoint geo() {
        return this.geo;
    }

    @Override
    @Nullable
    public InlineQueryPeerType peerType() {
        return this.peerType;
    }

    @Override
    public String offset() {
        return this.offset;
    }

    public final ImmutableUpdateBotInlineQuery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(value, this.flags, this.queryId, this.userId, this.query, this.geo, this.peerType, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, value, this.queryId, this.userId, this.query, this.geo, this.peerType, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, this.flags, value, this.userId, this.query, this.geo, this.peerType, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, this.flags, this.queryId, value, this.query, this.geo, this.peerType, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, this.flags, this.queryId, this.userId, newValue, this.geo, this.peerType, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withGeo(@Nullable GeoPoint value) {
        if (this.geo == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, this.flags, this.queryId, this.userId, this.query, value, this.peerType, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withPeerType(@Nullable InlineQueryPeerType value) {
        if (this.peerType == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, this.flags, this.queryId, this.userId, this.query, this.geo, value, this.offset);
    }

    public final ImmutableUpdateBotInlineQuery withOffset(String value) {
        String newValue = Objects.requireNonNull(value, "offset");
        if (this.offset.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateBotInlineQuery(this.identifier, this.flags, this.queryId, this.userId, this.query, this.geo, this.peerType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotInlineQuery && this.equalTo(0, (ImmutableUpdateBotInlineQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotInlineQuery another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.queryId == another.queryId && this.userId == another.userId && this.query.equals(another.query) && Objects.equals(this.geo, another.geo) && Objects.equals((Object)this.peerType, (Object)another.peerType) && this.offset.equals(another.offset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + Objects.hashCode(this.geo);
        h += (h << 5) + Objects.hashCode((Object)this.peerType);
        h += (h << 5) + this.offset.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateBotInlineQuery{identifier=" + this.identifier + ", flags=" + this.flags + ", queryId=" + this.queryId + ", userId=" + this.userId + ", query=" + this.query + ", geo=" + this.geo + ", peerType=" + this.peerType + ", offset=" + this.offset + "}";
    }

    public static ImmutableUpdateBotInlineQuery of(long queryId, long userId, String query, String offset) {
        return new ImmutableUpdateBotInlineQuery(queryId, userId, query, offset);
    }

    public static ImmutableUpdateBotInlineQuery copyOf(UpdateBotInlineQuery instance) {
        if (instance instanceof ImmutableUpdateBotInlineQuery) {
            return (ImmutableUpdateBotInlineQuery)instance;
        }
        return ImmutableUpdateBotInlineQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_QUERY = 4L;
        private static final long INIT_BIT_OFFSET = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private long queryId;
        private long userId;
        private String query;
        private GeoPoint geo;
        private InlineQueryPeerType peerType;
        private String offset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateBotInlineQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateBotInlineQuery) {
                instance = (UpdateBotInlineQuery)object;
                GeoPoint geoValue = instance.geo();
                if (geoValue != null) {
                    this.geo(geoValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.query(instance.query());
                this.flags(instance.flags());
                InlineQueryPeerType peerTypeValue = instance.peerType();
                if (peerTypeValue != null) {
                    this.peerType(peerTypeValue);
                }
                this.userId(instance.userId());
                this.queryId(instance.queryId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder geo(@Nullable GeoPoint geo) {
            this.geo = geo;
            return this;
        }

        public final Builder peerType(@Nullable InlineQueryPeerType peerType) {
            this.peerType = peerType;
            return this;
        }

        public final Builder offset(String offset) {
            this.offset = Objects.requireNonNull(offset, "offset");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateBotInlineQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotInlineQuery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("query");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build UpdateBotInlineQuery, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateBotInlineQuery.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateBotInlineQuery.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateBotInlineQuery, attribute initializers form cycle " + attributes;
        }
    }
}

