/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotInlineSend;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotInlineSend
implements UpdateBotInlineSend {
    private final int identifier;
    private final int flags;
    private final long userId;
    private final String query;
    @Nullable
    private final GeoPoint geo;
    private final String id;
    @Nullable
    private final InputBotInlineMessageID msgId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateBotInlineSend(long userId, String query, String id) {
        this.userId = userId;
        this.query = Objects.requireNonNull(query, "query");
        this.id = Objects.requireNonNull(id, "id");
        this.geo = null;
        this.msgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateBotInlineSend(Builder builder) {
        this.userId = builder.userId;
        this.query = builder.query;
        this.geo = builder.geo;
        this.id = builder.id;
        this.msgId = builder.msgId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateBotInlineSend(int identifier, int flags, long userId, String query, @Nullable GeoPoint geo, String id, @Nullable InputBotInlineMessageID msgId) {
        this.identifier = identifier;
        this.flags = flags;
        this.userId = userId;
        this.query = query;
        this.geo = geo;
        this.id = id;
        this.msgId = msgId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateBotInlineSend.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateBotInlineSend.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    @Nullable
    public GeoPoint geo() {
        return this.geo;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public InputBotInlineMessageID msgId() {
        return this.msgId;
    }

    public final ImmutableUpdateBotInlineSend withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(value, this.flags, this.userId, this.query, this.geo, this.id, this.msgId);
    }

    public final ImmutableUpdateBotInlineSend withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(this.identifier, value, this.userId, this.query, this.geo, this.id, this.msgId);
    }

    public final ImmutableUpdateBotInlineSend withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(this.identifier, this.flags, value, this.query, this.geo, this.id, this.msgId);
    }

    public final ImmutableUpdateBotInlineSend withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(this.identifier, this.flags, this.userId, newValue, this.geo, this.id, this.msgId);
    }

    public final ImmutableUpdateBotInlineSend withGeo(@Nullable GeoPoint value) {
        if (this.geo == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(this.identifier, this.flags, this.userId, this.query, value, this.id, this.msgId);
    }

    public final ImmutableUpdateBotInlineSend withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(this.identifier, this.flags, this.userId, this.query, this.geo, newValue, this.msgId);
    }

    public final ImmutableUpdateBotInlineSend withMsgId(@Nullable InputBotInlineMessageID value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableUpdateBotInlineSend(this.identifier, this.flags, this.userId, this.query, this.geo, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotInlineSend && this.equalTo(0, (ImmutableUpdateBotInlineSend)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotInlineSend another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.userId == another.userId && this.query.equals(another.query) && Objects.equals(this.geo, another.geo) && this.id.equals(another.id) && Objects.equals(this.msgId, another.msgId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + Objects.hashCode(this.geo);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.msgId);
        return h;
    }

    public String toString() {
        return "UpdateBotInlineSend{identifier=" + this.identifier + ", flags=" + this.flags + ", userId=" + this.userId + ", query=" + this.query + ", geo=" + this.geo + ", id=" + this.id + ", msgId=" + this.msgId + "}";
    }

    public static ImmutableUpdateBotInlineSend of(long userId, String query, String id) {
        return new ImmutableUpdateBotInlineSend(userId, query, id);
    }

    public static ImmutableUpdateBotInlineSend copyOf(UpdateBotInlineSend instance) {
        if (instance instanceof ImmutableUpdateBotInlineSend) {
            return (ImmutableUpdateBotInlineSend)instance;
        }
        return ImmutableUpdateBotInlineSend.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private long userId;
        private String query;
        private GeoPoint geo;
        private String id;
        private InputBotInlineMessageID msgId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateBotInlineSend instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateBotInlineSend) {
                instance = (UpdateBotInlineSend)object;
                GeoPoint geoValue = instance.geo();
                if (geoValue != null) {
                    this.geo(geoValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.query(instance.query());
                this.flags(instance.flags());
                InputBotInlineMessageID msgIdValue = instance.msgId();
                if (msgIdValue != null) {
                    this.msgId(msgIdValue);
                }
                this.id(instance.id());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder geo(@Nullable GeoPoint geo) {
            this.geo = geo;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder msgId(@Nullable InputBotInlineMessageID msgId) {
            this.msgId = msgId;
            return this;
        }

        public ImmutableUpdateBotInlineSend build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotInlineSend(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("query");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build UpdateBotInlineSend, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateBotInlineSend.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateBotInlineSend.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateBotInlineSend, attribute initializers form cycle " + attributes;
        }
    }
}

