/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotMenuButton;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotMenuButton;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotMenuButton
implements UpdateBotMenuButton {
    private final int identifier;
    private final long botId;
    private final BotMenuButton button;

    private ImmutableUpdateBotMenuButton(long botId, BotMenuButton button) {
        this.botId = botId;
        this.button = Objects.requireNonNull(button, "button");
        this.identifier = UpdateBotMenuButton.super.identifier();
    }

    private ImmutableUpdateBotMenuButton(Builder builder) {
        this.botId = builder.botId;
        this.button = builder.button;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateBotMenuButton.super.identifier();
    }

    private ImmutableUpdateBotMenuButton(int identifier, long botId, BotMenuButton button) {
        this.identifier = identifier;
        this.botId = botId;
        this.button = button;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public BotMenuButton button() {
        return this.button;
    }

    public final ImmutableUpdateBotMenuButton withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotMenuButton(value, this.botId, this.button);
    }

    public final ImmutableUpdateBotMenuButton withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutableUpdateBotMenuButton(this.identifier, value, this.button);
    }

    public final ImmutableUpdateBotMenuButton withButton(BotMenuButton value) {
        if (this.button == value) {
            return this;
        }
        BotMenuButton newValue = Objects.requireNonNull(value, "button");
        return new ImmutableUpdateBotMenuButton(this.identifier, this.botId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotMenuButton && this.equalTo(0, (ImmutableUpdateBotMenuButton)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotMenuButton another) {
        return this.identifier == another.identifier && this.botId == another.botId && this.button.equals(another.button);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.button.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateBotMenuButton{identifier=" + this.identifier + ", botId=" + this.botId + ", button=" + this.button + "}";
    }

    public static ImmutableUpdateBotMenuButton of(long botId, BotMenuButton button) {
        return new ImmutableUpdateBotMenuButton(botId, button);
    }

    public static ImmutableUpdateBotMenuButton copyOf(UpdateBotMenuButton instance) {
        if (instance instanceof ImmutableUpdateBotMenuButton) {
            return (ImmutableUpdateBotMenuButton)instance;
        }
        return ImmutableUpdateBotMenuButton.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT_ID = 1L;
        private static final long INIT_BIT_BUTTON = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long botId;
        private BotMenuButton button;

        private Builder() {
        }

        public final Builder from(UpdateBotMenuButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateBotMenuButton) {
                instance = (UpdateBotMenuButton)object;
                this.button(instance.button());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botId(instance.botId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder button(BotMenuButton button) {
            this.button = Objects.requireNonNull(button, "button");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateBotMenuButton build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotMenuButton(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("button");
            }
            return "Cannot build UpdateBotMenuButton, some of required attributes are not set " + attributes;
        }
    }
}

