/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotPrecheckoutQuery;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotPrecheckoutQuery
implements UpdateBotPrecheckoutQuery {
    private final int identifier;
    private final int flags;
    private final long queryId;
    private final long userId;
    private final ByteBuf payload;
    @Nullable
    private final PaymentRequestedInfo info;
    @Nullable
    private final String shippingOptionId;
    private final String currency;
    private final long totalAmount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateBotPrecheckoutQuery(long queryId, long userId, String currency, long totalAmount) {
        this.queryId = queryId;
        this.userId = userId;
        this.currency = Objects.requireNonNull(currency, "currency");
        this.totalAmount = totalAmount;
        this.payload = null;
        this.info = null;
        this.shippingOptionId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateBotPrecheckoutQuery(Builder builder) {
        this.queryId = builder.queryId;
        this.userId = builder.userId;
        this.payload = builder.payload_build();
        this.info = builder.info;
        this.shippingOptionId = builder.shippingOptionId;
        this.currency = builder.currency;
        this.totalAmount = builder.totalAmount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateBotPrecheckoutQuery(int identifier, int flags, long queryId, long userId, ByteBuf payload, @Nullable PaymentRequestedInfo info, @Nullable String shippingOptionId, String currency, long totalAmount) {
        this.identifier = identifier;
        this.flags = flags;
        this.queryId = queryId;
        this.userId = userId;
        this.payload = payload;
        this.info = info;
        this.shippingOptionId = shippingOptionId;
        this.currency = currency;
        this.totalAmount = totalAmount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateBotPrecheckoutQuery.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateBotPrecheckoutQuery.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public ByteBuf payload() {
        return this.payload.duplicate();
    }

    @Override
    @Nullable
    public PaymentRequestedInfo info() {
        return this.info;
    }

    @Override
    @Nullable
    public String shippingOptionId() {
        return this.shippingOptionId;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long totalAmount() {
        return this.totalAmount;
    }

    public final ImmutableUpdateBotPrecheckoutQuery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(value, this.flags, this.queryId, this.userId, this.payload, this.info, this.shippingOptionId, this.currency, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, value, this.queryId, this.userId, this.payload, this.info, this.shippingOptionId, this.currency, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, value, this.userId, this.payload, this.info, this.shippingOptionId, this.currency, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, this.queryId, value, this.payload, this.info, this.shippingOptionId, this.currency, this.totalAmount);
    }

    public ImmutableUpdateBotPrecheckoutQuery withPayload(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.payload == newValue) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, this.queryId, this.userId, newValue, this.info, this.shippingOptionId, this.currency, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withInfo(@Nullable PaymentRequestedInfo value) {
        if (this.info == value) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, this.queryId, this.userId, this.payload, value, this.shippingOptionId, this.currency, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withShippingOptionId(@Nullable String value) {
        if (Objects.equals(this.shippingOptionId, value)) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, this.queryId, this.userId, this.payload, this.info, value, this.currency, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, this.queryId, this.userId, this.payload, this.info, this.shippingOptionId, newValue, this.totalAmount);
    }

    public final ImmutableUpdateBotPrecheckoutQuery withTotalAmount(long value) {
        if (this.totalAmount == value) {
            return this;
        }
        return new ImmutableUpdateBotPrecheckoutQuery(this.identifier, this.flags, this.queryId, this.userId, this.payload, this.info, this.shippingOptionId, this.currency, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotPrecheckoutQuery && this.equalTo(0, (ImmutableUpdateBotPrecheckoutQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotPrecheckoutQuery another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.queryId == another.queryId && this.userId == another.userId && this.payload().equals((Object)another.payload()) && Objects.equals(this.info, another.info) && Objects.equals(this.shippingOptionId, another.shippingOptionId) && this.currency.equals(another.currency) && this.totalAmount == another.totalAmount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.payload().hashCode();
        h += (h << 5) + Objects.hashCode(this.info);
        h += (h << 5) + Objects.hashCode(this.shippingOptionId);
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.totalAmount);
        return h;
    }

    public String toString() {
        return "UpdateBotPrecheckoutQuery{identifier=" + this.identifier + ", flags=" + this.flags + ", queryId=" + this.queryId + ", userId=" + this.userId + ", payload=" + ByteBufUtil.hexDump((ByteBuf)this.payload) + ", info=" + this.info + ", shippingOptionId=" + this.shippingOptionId + ", currency=" + this.currency + ", totalAmount=" + this.totalAmount + "}";
    }

    public static ImmutableUpdateBotPrecheckoutQuery of(long queryId, long userId, String currency, long totalAmount) {
        return new ImmutableUpdateBotPrecheckoutQuery(queryId, userId, currency, totalAmount);
    }

    public static ImmutableUpdateBotPrecheckoutQuery copyOf(UpdateBotPrecheckoutQuery instance) {
        if (instance instanceof ImmutableUpdateBotPrecheckoutQuery) {
            return (ImmutableUpdateBotPrecheckoutQuery)instance;
        }
        return ImmutableUpdateBotPrecheckoutQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_CURRENCY = 4L;
        private static final long INIT_BIT_TOTAL_AMOUNT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private ByteBuf payload_value = null;
        private int identifier;
        private int flags;
        private long queryId;
        private long userId;
        private PaymentRequestedInfo info;
        private String shippingOptionId;
        private String currency;
        private long totalAmount;

        private Builder() {
        }

        public final Builder from(UpdateBotPrecheckoutQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateBotPrecheckoutQuery) {
                instance = (UpdateBotPrecheckoutQuery)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.totalAmount(instance.totalAmount());
                this.payload(instance.payload());
                this.flags(instance.flags());
                this.currency(instance.currency());
                String shippingOptionIdValue = instance.shippingOptionId();
                if (shippingOptionIdValue != null) {
                    this.shippingOptionId(shippingOptionIdValue);
                }
                this.userId(instance.userId());
                this.queryId(instance.queryId());
                PaymentRequestedInfo infoValue = instance.info();
                if (infoValue != null) {
                    this.info(infoValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder payload(ByteBuf value) {
            this.payload_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder info(@Nullable PaymentRequestedInfo info) {
            this.info = info;
            return this;
        }

        public final Builder shippingOptionId(@Nullable String shippingOptionId) {
            this.shippingOptionId = shippingOptionId;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder totalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateBotPrecheckoutQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotPrecheckoutQuery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("totalAmount");
            }
            return "Cannot build UpdateBotPrecheckoutQuery, some of required attributes are not set " + attributes;
        }

        private ByteBuf payload_build() {
            return Objects.requireNonNull(this.payload_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateBotPrecheckoutQuery.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateBotPrecheckoutQuery.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateBotPrecheckoutQuery, attribute initializers form cycle " + attributes;
        }
    }
}

