/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PostAddress;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotShippingQuery;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotShippingQuery
implements UpdateBotShippingQuery {
    private final int identifier;
    private final long queryId;
    private final long userId;
    private final ByteBuf payload;
    private final PostAddress shippingAddress;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateBotShippingQuery(long queryId, long userId, PostAddress shippingAddress) {
        this.queryId = queryId;
        this.userId = userId;
        this.shippingAddress = Objects.requireNonNull(shippingAddress, "shippingAddress");
        this.payload = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableUpdateBotShippingQuery(Builder builder) {
        this.queryId = builder.queryId;
        this.userId = builder.userId;
        this.payload = builder.payload_build();
        this.shippingAddress = builder.shippingAddress;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableUpdateBotShippingQuery(int identifier, long queryId, long userId, ByteBuf payload, PostAddress shippingAddress) {
        this.identifier = identifier;
        this.queryId = queryId;
        this.userId = userId;
        this.payload = payload;
        this.shippingAddress = shippingAddress;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateBotShippingQuery.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public ByteBuf payload() {
        return this.payload.duplicate();
    }

    @Override
    public PostAddress shippingAddress() {
        return this.shippingAddress;
    }

    public final ImmutableUpdateBotShippingQuery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotShippingQuery(value, this.queryId, this.userId, this.payload, this.shippingAddress);
    }

    public final ImmutableUpdateBotShippingQuery withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableUpdateBotShippingQuery(this.identifier, value, this.userId, this.payload, this.shippingAddress);
    }

    public final ImmutableUpdateBotShippingQuery withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateBotShippingQuery(this.identifier, this.queryId, value, this.payload, this.shippingAddress);
    }

    public ImmutableUpdateBotShippingQuery withPayload(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.payload == newValue) {
            return this;
        }
        return new ImmutableUpdateBotShippingQuery(this.identifier, this.queryId, this.userId, newValue, this.shippingAddress);
    }

    public final ImmutableUpdateBotShippingQuery withShippingAddress(PostAddress value) {
        if (this.shippingAddress == value) {
            return this;
        }
        PostAddress newValue = Objects.requireNonNull(value, "shippingAddress");
        return new ImmutableUpdateBotShippingQuery(this.identifier, this.queryId, this.userId, this.payload, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotShippingQuery && this.equalTo(0, (ImmutableUpdateBotShippingQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotShippingQuery another) {
        return this.identifier == another.identifier && this.queryId == another.queryId && this.userId == another.userId && this.payload().equals((Object)another.payload()) && this.shippingAddress.equals(another.shippingAddress);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.payload().hashCode();
        h += (h << 5) + this.shippingAddress.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateBotShippingQuery{identifier=" + this.identifier + ", queryId=" + this.queryId + ", userId=" + this.userId + ", payload=" + ByteBufUtil.hexDump((ByteBuf)this.payload) + ", shippingAddress=" + this.shippingAddress + "}";
    }

    public static ImmutableUpdateBotShippingQuery of(long queryId, long userId, PostAddress shippingAddress) {
        return new ImmutableUpdateBotShippingQuery(queryId, userId, shippingAddress);
    }

    public static ImmutableUpdateBotShippingQuery copyOf(UpdateBotShippingQuery instance) {
        if (instance instanceof ImmutableUpdateBotShippingQuery) {
            return (ImmutableUpdateBotShippingQuery)instance;
        }
        return ImmutableUpdateBotShippingQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_SHIPPING_ADDRESS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf payload_value = null;
        private int identifier;
        private long queryId;
        private long userId;
        private PostAddress shippingAddress;

        private Builder() {
        }

        public final Builder from(UpdateBotShippingQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateBotShippingQuery) {
                instance = (UpdateBotShippingQuery)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.shippingAddress(instance.shippingAddress());
                this.payload(instance.payload());
                this.userId(instance.userId());
                this.queryId(instance.queryId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder payload(ByteBuf value) {
            this.payload_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder shippingAddress(PostAddress shippingAddress) {
            this.shippingAddress = Objects.requireNonNull(shippingAddress, "shippingAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateBotShippingQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotShippingQuery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("shippingAddress");
            }
            return "Cannot build UpdateBotShippingQuery, some of required attributes are not set " + attributes;
        }

        private ByteBuf payload_build() {
            return Objects.requireNonNull(this.payload_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateBotShippingQuery.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build UpdateBotShippingQuery, attribute initializers form cycle " + attributes;
        }
    }
}

