/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.QtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotStopped;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotStopped
implements UpdateBotStopped {
    private final int identifier;
    private final long userId;
    private final int date;
    private final boolean stopped;
    private final int qts;

    private ImmutableUpdateBotStopped(long userId, int date, boolean stopped, int qts) {
        this.userId = userId;
        this.date = date;
        this.stopped = stopped;
        this.qts = qts;
        this.identifier = UpdateBotStopped.super.identifier();
    }

    private ImmutableUpdateBotStopped(Builder builder) {
        this.userId = builder.userId;
        this.date = builder.date;
        this.stopped = builder.stopped;
        this.qts = builder.qts;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateBotStopped.super.identifier();
    }

    private ImmutableUpdateBotStopped(int identifier, long userId, int date, boolean stopped, int qts) {
        this.identifier = identifier;
        this.userId = userId;
        this.date = date;
        this.stopped = stopped;
        this.qts = qts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public boolean stopped() {
        return this.stopped;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableUpdateBotStopped withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotStopped(value, this.userId, this.date, this.stopped, this.qts);
    }

    public final ImmutableUpdateBotStopped withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateBotStopped(this.identifier, value, this.date, this.stopped, this.qts);
    }

    public final ImmutableUpdateBotStopped withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateBotStopped(this.identifier, this.userId, value, this.stopped, this.qts);
    }

    public final ImmutableUpdateBotStopped withStopped(boolean value) {
        if (this.stopped == value) {
            return this;
        }
        return new ImmutableUpdateBotStopped(this.identifier, this.userId, this.date, value, this.qts);
    }

    public final ImmutableUpdateBotStopped withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableUpdateBotStopped(this.identifier, this.userId, this.date, this.stopped, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotStopped && this.equalTo(0, (ImmutableUpdateBotStopped)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotStopped another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.date == another.date && this.stopped == another.stopped && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.date;
        h += (h << 5) + Boolean.hashCode(this.stopped);
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "UpdateBotStopped{identifier=" + this.identifier + ", userId=" + this.userId + ", date=" + this.date + ", stopped=" + this.stopped + ", qts=" + this.qts + "}";
    }

    public static ImmutableUpdateBotStopped of(long userId, int date, boolean stopped, int qts) {
        return new ImmutableUpdateBotStopped(userId, date, stopped, qts);
    }

    public static ImmutableUpdateBotStopped copyOf(UpdateBotStopped instance) {
        if (instance instanceof ImmutableUpdateBotStopped) {
            return (ImmutableUpdateBotStopped)instance;
        }
        return ImmutableUpdateBotStopped.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_STOPPED = 4L;
        private static final long INIT_BIT_QTS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long userId;
        private int date;
        private boolean stopped;
        private int qts;

        private Builder() {
        }

        public final Builder from(QtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateBotStopped instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof QtsUpdate) {
                instance = (QtsUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
            }
            if (object instanceof UpdateBotStopped) {
                instance = (UpdateBotStopped)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
                this.stopped(instance.stopped());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stopped(boolean stopped) {
            this.stopped = stopped;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateBotStopped build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotStopped(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stopped");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build UpdateBotStopped, some of required attributes are not set " + attributes;
        }
    }
}

