/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotWebhookJSON;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotWebhookJSON
implements UpdateBotWebhookJSON {
    private final int identifier;
    private final DataJSON data;

    private ImmutableUpdateBotWebhookJSON(DataJSON data) {
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = UpdateBotWebhookJSON.super.identifier();
    }

    private ImmutableUpdateBotWebhookJSON(Builder builder) {
        this.data = builder.data;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateBotWebhookJSON.super.identifier();
    }

    private ImmutableUpdateBotWebhookJSON(int identifier, DataJSON data) {
        this.identifier = identifier;
        this.data = data;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public DataJSON data() {
        return this.data;
    }

    public final ImmutableUpdateBotWebhookJSON withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotWebhookJSON(value, this.data);
    }

    public final ImmutableUpdateBotWebhookJSON withData(DataJSON value) {
        if (this.data == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "data");
        return new ImmutableUpdateBotWebhookJSON(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotWebhookJSON && this.equalTo(0, (ImmutableUpdateBotWebhookJSON)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotWebhookJSON another) {
        return this.identifier == another.identifier && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateBotWebhookJSON{identifier=" + this.identifier + ", data=" + this.data + "}";
    }

    public static ImmutableUpdateBotWebhookJSON of(DataJSON data) {
        return new ImmutableUpdateBotWebhookJSON(data);
    }

    public static ImmutableUpdateBotWebhookJSON copyOf(UpdateBotWebhookJSON instance) {
        if (instance instanceof ImmutableUpdateBotWebhookJSON) {
            return (ImmutableUpdateBotWebhookJSON)instance;
        }
        return ImmutableUpdateBotWebhookJSON.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATA = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private DataJSON data;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateBotWebhookJSON instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateBotWebhookJSON) {
                instance = (UpdateBotWebhookJSON)object;
                this.data(instance.data());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder data(DataJSON data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateBotWebhookJSON build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotWebhookJSON(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build UpdateBotWebhookJSON, some of required attributes are not set " + attributes;
        }
    }
}

