/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateBotWebhookJSONQuery;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateBotWebhookJSONQuery
implements UpdateBotWebhookJSONQuery {
    private final int identifier;
    private final long queryId;
    private final DataJSON data;
    private final int timeout;

    private ImmutableUpdateBotWebhookJSONQuery(long queryId, DataJSON data, int timeout) {
        this.queryId = queryId;
        this.data = Objects.requireNonNull(data, "data");
        this.timeout = timeout;
        this.identifier = UpdateBotWebhookJSONQuery.super.identifier();
    }

    private ImmutableUpdateBotWebhookJSONQuery(Builder builder) {
        this.queryId = builder.queryId;
        this.data = builder.data;
        this.timeout = builder.timeout;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateBotWebhookJSONQuery.super.identifier();
    }

    private ImmutableUpdateBotWebhookJSONQuery(int identifier, long queryId, DataJSON data, int timeout) {
        this.identifier = identifier;
        this.queryId = queryId;
        this.data = data;
        this.timeout = timeout;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public DataJSON data() {
        return this.data;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    public final ImmutableUpdateBotWebhookJSONQuery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateBotWebhookJSONQuery(value, this.queryId, this.data, this.timeout);
    }

    public final ImmutableUpdateBotWebhookJSONQuery withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableUpdateBotWebhookJSONQuery(this.identifier, value, this.data, this.timeout);
    }

    public final ImmutableUpdateBotWebhookJSONQuery withData(DataJSON value) {
        if (this.data == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "data");
        return new ImmutableUpdateBotWebhookJSONQuery(this.identifier, this.queryId, newValue, this.timeout);
    }

    public final ImmutableUpdateBotWebhookJSONQuery withTimeout(int value) {
        if (this.timeout == value) {
            return this;
        }
        return new ImmutableUpdateBotWebhookJSONQuery(this.identifier, this.queryId, this.data, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateBotWebhookJSONQuery && this.equalTo(0, (ImmutableUpdateBotWebhookJSONQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateBotWebhookJSONQuery another) {
        return this.identifier == another.identifier && this.queryId == another.queryId && this.data.equals(another.data) && this.timeout == another.timeout;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + this.timeout;
        return h;
    }

    public String toString() {
        return "UpdateBotWebhookJSONQuery{identifier=" + this.identifier + ", queryId=" + this.queryId + ", data=" + this.data + ", timeout=" + this.timeout + "}";
    }

    public static ImmutableUpdateBotWebhookJSONQuery of(long queryId, DataJSON data, int timeout) {
        return new ImmutableUpdateBotWebhookJSONQuery(queryId, data, timeout);
    }

    public static ImmutableUpdateBotWebhookJSONQuery copyOf(UpdateBotWebhookJSONQuery instance) {
        if (instance instanceof ImmutableUpdateBotWebhookJSONQuery) {
            return (ImmutableUpdateBotWebhookJSONQuery)instance;
        }
        return ImmutableUpdateBotWebhookJSONQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_DATA = 2L;
        private static final long INIT_BIT_TIMEOUT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long queryId;
        private DataJSON data;
        private int timeout;

        private Builder() {
        }

        public final Builder from(UpdateBotWebhookJSONQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateBotWebhookJSONQuery) {
                instance = (UpdateBotWebhookJSONQuery)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.data(instance.data());
                this.timeout(instance.timeout());
                this.queryId(instance.queryId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder data(DataJSON data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder timeout(int timeout) {
            this.timeout = timeout;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateBotWebhookJSONQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateBotWebhookJSONQuery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("data");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timeout");
            }
            return "Cannot build UpdateBotWebhookJSONQuery, some of required attributes are not set " + attributes;
        }
    }
}

