/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannel;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannel
implements UpdateChannel {
    private final int identifier;
    private final long channelId;

    private ImmutableUpdateChannel(long channelId) {
        this.channelId = channelId;
        this.identifier = UpdateChannel.super.identifier();
    }

    private ImmutableUpdateChannel(Builder builder) {
        this.channelId = builder.channelId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChannel.super.identifier();
    }

    private ImmutableUpdateChannel(int identifier, long channelId) {
        this.identifier = identifier;
        this.channelId = channelId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    public final ImmutableUpdateChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannel(value, this.channelId);
    }

    public final ImmutableUpdateChannel withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannel(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannel && this.equalTo(0, (ImmutableUpdateChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannel another) {
        return this.identifier == another.identifier && this.channelId == another.channelId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        return h;
    }

    public String toString() {
        return "UpdateChannel{identifier=" + this.identifier + ", channelId=" + this.channelId + "}";
    }

    public static ImmutableUpdateChannel of(long channelId) {
        return new ImmutableUpdateChannel(channelId);
    }

    public static ImmutableUpdateChannel copyOf(UpdateChannel instance) {
        if (instance instanceof ImmutableUpdateChannel) {
            return (ImmutableUpdateChannel)instance;
        }
        return ImmutableUpdateChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long channelId;

        private Builder() {
        }

        public final Builder from(UpdateChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannel) {
                instance = (UpdateChannel)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.channelId(instance.channelId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            return "Cannot build UpdateChannel, some of required attributes are not set " + attributes;
        }
    }
}

